/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;

enum FieldDescriptorValidator {
    ALLOW_ALL{

        @Override
        void validate(Descriptors.FieldDescriptor fieldDescriptor) {
        }
    }
    ,
    IS_FIELD_WITH_ABSENCE{

        @Override
        void validate(Descriptors.FieldDescriptor fieldDescriptor) {
            Preconditions.checkArgument((!fieldDescriptor.isRepeated() ? 1 : 0) != 0, (String)"%s is a repeated field; repeated fields cannot be absent, only empty", (Object)fieldDescriptor);
            Preconditions.checkArgument((boolean)fieldDescriptor.hasPresence(), (String)"%s is a field without presence; it cannot be absent", (Object)fieldDescriptor);
        }
    }
    ,
    IS_FIELD_WITH_ORDER{

        @Override
        void validate(Descriptors.FieldDescriptor fieldDescriptor) {
            Preconditions.checkArgument((!fieldDescriptor.isMapField() ? 1 : 0) != 0, (String)"%s is a map field; it has no order", (Object)fieldDescriptor);
            Preconditions.checkArgument((boolean)fieldDescriptor.isRepeated(), (String)"%s is not a repeated field; it has no order", (Object)fieldDescriptor);
        }
    }
    ,
    IS_FIELD_WITH_EXTRA_ELEMENTS{

        @Override
        void validate(Descriptors.FieldDescriptor fieldDescriptor) {
            Preconditions.checkArgument((boolean)fieldDescriptor.isRepeated(), (String)"%s is not a repeated field or a map field; it cannot contain extra elements", (Object)fieldDescriptor);
        }
    }
    ,
    IS_DOUBLE_FIELD{

        @Override
        void validate(Descriptors.FieldDescriptor fieldDescriptor) {
            Preconditions.checkArgument((fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.DOUBLE ? 1 : 0) != 0, (String)"%s is not a double field", (Object)fieldDescriptor);
        }
    }
    ,
    IS_FLOAT_FIELD{

        @Override
        void validate(Descriptors.FieldDescriptor fieldDescriptor) {
            Preconditions.checkArgument((fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.FLOAT ? 1 : 0) != 0, (String)"%s is not a float field", (Object)fieldDescriptor);
        }
    };


    abstract void validate(Descriptors.FieldDescriptor var1);
}

