/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintAbstractState;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTreeHeapFollowerAbstractState;
import proguard.analysis.cpa.jvm.operators.JvmDefaultExpandOperator;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.util.HeapUtil;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Signature;
import proguard.classfile.instruction.Instruction;

public class JvmTaintExpandOperator
extends JvmDefaultExpandOperator<SetAbstractState<JvmTaintSource>> {
    private final Map<Signature, Set<JvmTaintSource>> signaturesToSources;

    public JvmTaintExpandOperator(JvmCfa cfa, Map<Signature, Set<JvmTaintSource>> signaturesToSources, boolean expandHeap) {
        super(cfa, expandHeap);
        this.signaturesToSources = signaturesToSources;
    }

    public JvmTaintExpandOperator(JvmCfa cfa, Map<Signature, Set<JvmTaintSource>> signaturesToSources) {
        this(cfa, signaturesToSources, true);
    }

    public JvmTaintAbstractState expand(AbstractState expandedInitialState, AbstractState reducedExitState, JvmCfaNode blockEntryNode, Call call) {
        JvmTaintAbstractState result = (JvmTaintAbstractState)super.expand(expandedInitialState, reducedExitState, blockEntryNode, call);
        List detectedSources = this.signaturesToSources.getOrDefault(call.getTarget(), Collections.emptySet()).stream().filter(s -> s.callMatcher.map(m -> m.test(call)).orElse(true)).collect(Collectors.toList());
        if (detectedSources.isEmpty()) {
            return result;
        }
        HashMap<String, SetAbstractState> fqnToValue = new HashMap<String, SetAbstractState>();
        detectedSources.stream().filter(s -> !s.taintsGlobals.isEmpty()).forEach(s -> {
            SetAbstractState<JvmTaintSource> newValue = new SetAbstractState<JvmTaintSource>(s);
            s.taintsGlobals.forEach(fqn -> fqnToValue.merge((String)fqn, newValue, SetAbstractState::join));
        });
        fqnToValue.forEach((fqn, value) -> result.setStatic((String)fqn, value, SetAbstractState.bottom));
        if (!(result.getHeap() instanceof JvmTaintTreeHeapFollowerAbstractState)) {
            return result;
        }
        JvmTaintTreeHeapFollowerAbstractState expandedHeap = (JvmTaintTreeHeapFollowerAbstractState)((JvmTaintAbstractState)expandedInitialState).getHeap();
        fqnToValue.forEach((key, value) -> result.setObjectTaint(expandedHeap.getReferenceAbstractState(new JvmStaticFieldLocation((String)key)), (SetAbstractState<JvmTaintSource>)value));
        String descriptor = call.getTarget().descriptor.toString();
        int parameterSize = call.getJvmArgumentSize();
        HashMap<Integer, SetAbstractState> argToValue = new HashMap<Integer, SetAbstractState>();
        detectedSources.stream().filter(s -> !s.taintsArgs.isEmpty()).forEach(s -> {
            SetAbstractState<JvmTaintSource> newValue = new SetAbstractState<JvmTaintSource>(s);
            s.taintsArgs.forEach(a -> argToValue.merge((Integer)a, newValue, SetAbstractState::join));
        });
        argToValue.forEach((a, value) -> result.setObjectTaint(HeapUtil.getArgumentReference(expandedHeap, parameterSize, descriptor, call.isStatic(), a - 1), (SetAbstractState<JvmTaintSource>)value));
        List sourcesTaintingThis = detectedSources.stream().filter(s -> s.taintsThis).collect(Collectors.toList());
        if (!sourcesTaintingThis.isEmpty()) {
            result.setObjectTaint(expandedHeap.getReferenceAbstractState(new JvmStackLocation(parameterSize - 1)), new SetAbstractState<JvmTaintSource>(sourcesTaintingThis));
        }
        return result;
    }

    @Override
    protected List<SetAbstractState<JvmTaintSource>> calculateReturnValues(AbstractState reducedExitState, Instruction returnInstruction, Call call) {
        int i;
        List detectedSources = this.signaturesToSources.getOrDefault(call.getTarget(), Collections.emptySet()).stream().filter(s -> s.callMatcher.map(m -> m.test(call)).orElse(true)).filter(s -> s.taintsReturn).collect(Collectors.toList());
        if (detectedSources.isEmpty()) {
            return super.calculateReturnValues(reducedExitState, returnInstruction, call);
        }
        ArrayList<SetAbstractState<JvmTaintSource>> returnValues = new ArrayList<SetAbstractState<JvmTaintSource>>();
        SetAbstractState answerContent = new SetAbstractState(detectedSources);
        int returnSize = returnInstruction.stackPopCount(null);
        for (i = 0; i < returnSize; ++i) {
            SetAbstractState returnByte = (SetAbstractState)((JvmAbstractState)reducedExitState).peek(i);
            answerContent = answerContent.join(returnByte);
        }
        for (i = returnSize; i > 1; --i) {
            returnValues.add(SetAbstractState.bottom);
        }
        if (returnSize > 0) {
            returnValues.add(answerContent);
        }
        return returnValues;
    }

    public JvmTaintAbstractState createJvmAbstractState(JvmCfaNode programLocation, JvmFrameAbstractState<SetAbstractState<JvmTaintSource>> frame, JvmHeapAbstractState<SetAbstractState<JvmTaintSource>> heap, MapAbstractState<String, SetAbstractState<JvmTaintSource>> staticFields) {
        return new JvmTaintAbstractState(programLocation, frame, heap, staticFields);
    }

    public Map<Signature, Set<JvmTaintSource>> getSignaturesToSources() {
        return this.signaturesToSources;
    }
}

