/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.algorithms;

import java.util.LinkedHashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.cpa.defaults.PrecisionAdjustmentResult;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.Algorithm;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.analysis.cpa.interfaces.MergeOperator;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.interfaces.PrecisionAdjustment;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.interfaces.StopOperator;
import proguard.analysis.cpa.interfaces.TransferRelation;
import proguard.analysis.cpa.interfaces.Waitlist;

public class CpaAlgorithm
implements Algorithm {
    private static final Logger log = LogManager.getLogger(CpaAlgorithm.class);
    private final TransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final PrecisionAdjustment precisionAdjustment;

    public CpaAlgorithm(ConfigurableProgramAnalysis cpa) {
        this(cpa.getTransferRelation(), cpa.getMergeOperator(), cpa.getStopOperator(), cpa.getPrecisionAdjustment());
    }

    public CpaAlgorithm(TransferRelation transferRelation, MergeOperator mergeOperator, StopOperator stopOperator, PrecisionAdjustment precisionAdjustment) {
        this.transferRelation = transferRelation;
        this.mergeOperator = mergeOperator;
        this.stopOperator = stopOperator;
        this.precisionAdjustment = precisionAdjustment;
    }

    @Override
    public void run(ReachedSet reachedSet, Waitlist waitlist, AbortOperator abortOperator) {
        while (!waitlist.isEmpty()) {
            AbstractState currentState = waitlist.pop();
            try {
                if (abortOperator.abort(currentState)) {
                    return;
                }
                Precision currentPrecision = currentState.getPrecision();
                PrecisionAdjustmentResult precisionAdjustmentResult = this.precisionAdjustment.prec(currentState, currentPrecision, reachedSet.getReached(currentState));
                currentState = precisionAdjustmentResult.getAbstractState();
                currentPrecision = currentState.getPrecision();
                for (AbstractState abstractState : this.transferRelation.generateAbstractSuccessors(currentState, currentPrecision)) {
                    LinkedHashSet<AbstractState> gen = new LinkedHashSet<AbstractState>();
                    LinkedHashSet<AbstractState> kill = new LinkedHashSet<AbstractState>();
                    for (AbstractState abstractState2 : reachedSet.getReached(abstractState)) {
                        AbstractState mergedState = this.mergeOperator.merge(abstractState, abstractState2, abstractState.getPrecision());
                        if (mergedState.equals(abstractState2)) continue;
                        gen.add(mergedState);
                        kill.add(abstractState2);
                    }
                    reachedSet.addAll(gen);
                    reachedSet.removeAll(kill);
                    waitlist.addAll(gen);
                    waitlist.removeAll(kill);
                    if (this.stopOperator.stop(abstractState, reachedSet.getReached(abstractState), abstractState.getPrecision())) continue;
                    waitlist.add(abstractState);
                    reachedSet.add(abstractState);
                }
            }
            catch (Exception exception) {
                log.error("CPA run stopped for the following error: ", (Throwable)exception);
                waitlist.clear();
            }
        }
    }
}

