/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

@BugPattern(name="DoubleCheckedLocking", summary="Double-checked locking on non-volatile fields is unsafe", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class DoubleCheckedLocking
extends BugChecker
implements BugChecker.IfTreeMatcher {
    private static final ImmutableSet<String> IMMUTABLE_PRIMITIVES = ImmutableSet.of((Object)Boolean.class.getName(), (Object)Byte.class.getName(), (Object)Short.class.getName(), (Object)Integer.class.getName(), (Object)Character.class.getName(), (Object)Float.class.getName(), (Object[])new String[]{String.class.getName()});

    public Description matchIf(IfTree outerIf, VisitorState state) {
        DclInfo info = DoubleCheckedLocking.findDcl(outerIf);
        if (info == null) {
            return Description.NO_MATCH;
        }
        return switch (info.sym().getKind()) {
            case ElementKind.FIELD -> this.handleField(info.outerIf(), info.sym(), state);
            case ElementKind.LOCAL_VARIABLE -> this.handleLocal(info, state);
            default -> Description.NO_MATCH;
        };
    }

    private Description handleField(IfTree outerIf, Symbol.VarSymbol sym, VisitorState state) {
        if (sym.getModifiers().contains((Object)Modifier.VOLATILE)) {
            return Description.NO_MATCH;
        }
        if (DoubleCheckedLocking.isImmutable(sym.type, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder builder = this.buildDescription(outerIf);
        JCTree fieldDecl = DoubleCheckedLocking.findFieldDeclaration(state.getPath(), sym);
        if (fieldDecl != null) {
            builder.addFix((Fix)SuggestedFixes.addModifiers((Tree)fieldDecl, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.VOLATILE}).orElse(SuggestedFix.emptyFix()));
        }
        return builder.build();
    }

    private static boolean isImmutable(Type type, VisitorState state) {
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case CHAR: 
            case FLOAT: {
                return true;
            }
            case LONG: 
            case DOUBLE: {
                return true;
            }
        }
        return IMMUTABLE_PRIMITIVES.contains((Object)state.getTypes().erasure((Type)type).tsym.getQualifiedName().toString());
    }

    private Description handleLocal(DclInfo info, VisitorState state) {
        JCTree.JCExpressionStatement expr = DoubleCheckedLocking.getChild(info.synchTree().getBlock(), JCTree.JCExpressionStatement.class);
        if (expr == null) {
            return Description.NO_MATCH;
        }
        if (expr.getStartPosition() > ASTHelpers.getStartPosition((Tree)info.innerIf())) {
            return Description.NO_MATCH;
        }
        JCTree.JCExpression jCExpression = expr.getExpression();
        if (!(jCExpression instanceof JCTree.JCAssign)) {
            return Description.NO_MATCH;
        }
        JCTree.JCAssign assign = (JCTree.JCAssign)jCExpression;
        if (!Objects.equals(ASTHelpers.getSymbol((Tree)assign.getVariable()), info.sym())) {
            return Description.NO_MATCH;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)assign.getExpression());
        if (!(symbol instanceof Symbol.VarSymbol)) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol fvar = (Symbol.VarSymbol)symbol;
        if (fvar.getKind() != ElementKind.FIELD) {
            return Description.NO_MATCH;
        }
        return this.handleField(info.outerIf(), fvar, state);
    }

    private static @Nullable DclInfo findDcl(IfTree outerIf) {
        ExpressionTree outerIfTest = DoubleCheckedLocking.getNullCheckedExpression(outerIf.getCondition());
        if (outerIfTest == null) {
            return null;
        }
        SynchronizedTree synchTree = DoubleCheckedLocking.getChild(outerIf.getThenStatement(), SynchronizedTree.class);
        if (synchTree == null) {
            return null;
        }
        IfTree innerIf = DoubleCheckedLocking.getChild(synchTree.getBlock(), IfTree.class);
        if (innerIf == null) {
            return null;
        }
        ExpressionTree innerIfTest = DoubleCheckedLocking.getNullCheckedExpression(innerIf.getCondition());
        if (innerIfTest == null) {
            return null;
        }
        Symbol outerSym = ASTHelpers.getSymbol((Tree)outerIfTest);
        if (!Objects.equals(outerSym, ASTHelpers.getSymbol((Tree)innerIfTest))) {
            return null;
        }
        if (!(outerSym instanceof Symbol.VarSymbol)) {
            return null;
        }
        Symbol.VarSymbol var = (Symbol.VarSymbol)outerSym;
        return DclInfo.create(outerIf, synchTree, innerIf, var);
    }

    private static @Nullable ExpressionTree getNullCheckedExpression(ExpressionTree condition) {
        ExpressionTree other;
        if (!((condition = ASTHelpers.stripParentheses((ExpressionTree)condition)) instanceof BinaryTree)) {
            return null;
        }
        BinaryTree bin = (BinaryTree)condition;
        if (bin.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            other = bin.getRightOperand();
        } else if (bin.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            other = bin.getLeftOperand();
        } else {
            return null;
        }
        return other;
    }

    private static <T> T getChild(StatementTree tree, final Class<T> clazz) {
        return (T)tree.accept(new SimpleTreeVisitor<T, Void>(){

            @Override
            protected T defaultAction(Tree node, Void p) {
                if (clazz.isInstance(node)) {
                    return clazz.cast(node);
                }
                return null;
            }

            @Override
            public T visitBlock(BlockTree node, Void p) {
                return this.visit(node.getStatements());
            }

            private T visit(List<? extends Tree> tx) {
                for (Tree tree : tx) {
                    Object r = tree.accept(this, null);
                    if (r == null) continue;
                    return r;
                }
                return null;
            }
        }, null);
    }

    private static @Nullable JCTree findFieldDeclaration(TreePath path, Symbol.VarSymbol var) {
        for (TreePath curr = path; curr != null; curr = curr.getParentPath()) {
            Tree leaf = curr.getLeaf();
            if (!(leaf instanceof JCTree.JCClassDecl)) continue;
            JCTree.JCClassDecl classTree = (JCTree.JCClassDecl)leaf;
            for (JCTree tree : classTree.getMembers()) {
                if (!Objects.equals(var, ASTHelpers.getSymbol((Tree)tree))) continue;
                return tree;
            }
        }
        return null;
    }

    private record DclInfo(IfTree outerIf, SynchronizedTree synchTree, IfTree innerIf, Symbol.VarSymbol sym) {
        static DclInfo create(IfTree outerIf, SynchronizedTree synchTree, IfTree innerIf, Symbol.VarSymbol sym) {
            return new DclInfo(outerIf, synchTree, innerIf, sym);
        }
    }
}

