/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.matchers.Description;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;

@BugPattern(summary="This tag is invalid.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class InvalidSnippet
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private void scanTags(VisitorState state, DocTreePath path) {
        new InvalidTagChecker(state).scan(path, null);
    }

    public Description matchClass(ClassTree classTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            this.scanTags(state, path);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            this.scanTags(state, path);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            this.scanTags(state, path);
        }
        return Description.NO_MATCH;
    }

    final class InvalidTagChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;

        private InvalidTagChecker(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Void unused) {
            if (erroneousTree.getBody().startsWith("{@snippet")) {
                String message = "This @snippet tag looks to be malformed. Did you forget the \":\"? Snippets should start with \"{@snippet :\" followed by a newline.";
                this.state.reportMatch(InvalidSnippet.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).build());
            }
            return null;
        }

        @Override
        public Void scan(DocTree tree, Void unused) {
            return (Void)super.scan(tree, null);
        }
    }
}

