/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.argumentselectiondefects.AutoValue_InvocationInfo;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.List;

@AutoValue
abstract class InvocationInfo {
    InvocationInfo() {
    }

    abstract Tree tree();

    abstract Symbol.MethodSymbol symbol();

    abstract ImmutableList<Tree> actualParameters();

    abstract ImmutableList<Symbol.VarSymbol> formalParameters();

    abstract VisitorState state();

    static InvocationInfo createFromMethodInvocation(MethodInvocationTree tree, Symbol.MethodSymbol symbol, VisitorState state) {
        return new AutoValue_InvocationInfo(tree, symbol, (ImmutableList<Tree>)ImmutableList.copyOf(tree.getArguments()), InvocationInfo.getFormalParametersWithoutVarArgs(symbol), state);
    }

    static InvocationInfo createFromNewClass(NewClassTree tree, Symbol.MethodSymbol symbol, VisitorState state) {
        return new AutoValue_InvocationInfo(tree, symbol, (ImmutableList<Tree>)ImmutableList.copyOf(tree.getArguments()), InvocationInfo.getFormalParametersWithoutVarArgs(symbol), state);
    }

    private static ImmutableList<Symbol.VarSymbol> getFormalParametersWithoutVarArgs(Symbol.MethodSymbol invokedMethodSymbol) {
        List formalParameters = invokedMethodSymbol.getParameters();
        if (!formalParameters.isEmpty() && ((Name)((Symbol.VarSymbol)formalParameters.get(0)).getSimpleName()).toString().matches("this\\$[0-9]+")) {
            return ImmutableList.of();
        }
        int size = invokedMethodSymbol.isVarArgs() ? formalParameters.size() - 1 : formalParameters.size();
        return ImmutableList.copyOf(formalParameters.subList(0, size));
    }
}

