/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Using a Void-typed variable is potentially confusing, and can be replaced with a literal `null`.", severity=BugPattern.SeverityLevel.WARNING)
public final class VoidUsed
extends BugChecker
implements BugChecker.IdentifierTreeMatcher,
BugChecker.MemberSelectTreeMatcher {
    private static final ImmutableSet<ElementKind> KINDS = Sets.immutableEnumSet((Enum)ElementKind.PARAMETER, (Enum[])new ElementKind[]{ElementKind.LOCAL_VARIABLE, ElementKind.FIELD, ElementKind.BINDING_VARIABLE});

    public Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        return this.handle(tree, state);
    }

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return this.handle(tree, state);
    }

    private Description handle(Tree tree, VisitorState state) {
        AssignmentTree assignmentTree;
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof AssignmentTree && (assignmentTree = (AssignmentTree)parent).getVariable().equals(tree)) {
            return Description.NO_MATCH;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol == null || !KINDS.contains((Object)symbol.getKind()) || !ASTHelpers.isSameType((Type)symbol.type, (Type)((Type)Suppliers.JAVA_LANG_VOID_TYPE.get(state)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)"null"));
    }
}

