/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Prefer string concatenation over explicitly using `StringBuilder#append`, since `+` reads better and has equivalent or better performance.", severity=BugPattern.SeverityLevel.WARNING)
public class UnnecessaryStringBuilder
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.constructor().forClass("java.lang.StringBuilder");
    private static final Matcher<ExpressionTree> APPEND = MethodMatchers.instanceMethod().onExactClass("java.lang.StringBuilder").named("append");
    private static final Matcher<ExpressionTree> TO_STRING = MethodMatchers.instanceMethod().onExactClass("java.lang.StringBuilder").named("toString");
    private static final Supplier<Type> JAVA_LANG_APPENDABLE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.Appendable"));
    private static final Supplier<Type> JAVA_LANG_CHARSEQUENCE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.CharSequence"));

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        VariableTree variableTree;
        MethodInvocationTree methodInvocationTree;
        TreePath grandParent;
        Tree tree2;
        TreePath parentPath;
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ArrayList<ExpressionTree> parts = new ArrayList<ExpressionTree>();
        switch (tree.getArguments().size()) {
            case 0: {
                break;
            }
            case 1: {
                ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
                if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)argument), (Type)((Type)JAVA_LANG_CHARSEQUENCE.get(state)), (VisitorState)state)) break;
                parts.add(argument);
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        TreePath path = state.getPath();
        while ((parentPath = path.getParentPath()).getLeaf() instanceof MemberSelectTree && (tree2 = (grandParent = parentPath.getParentPath()).getLeaf()) instanceof MethodInvocationTree && (methodInvocationTree = (MethodInvocationTree)tree2).getMethodSelect().equals(parentPath.getLeaf())) {
            if (APPEND.matches((Tree)methodInvocationTree, state)) {
                if (methodInvocationTree.getArguments().size() != 1) {
                    return Description.NO_MATCH;
                }
                parts.add((ExpressionTree)Iterables.getOnlyElement(methodInvocationTree.getArguments()));
                path = parentPath.getParentPath();
                continue;
            }
            if (TO_STRING.matches((Tree)methodInvocationTree, state)) {
                return this.describeMatch(methodInvocationTree, (Fix)SuggestedFix.replace((Tree)methodInvocationTree, (String)UnnecessaryStringBuilder.replacement(state, parts)));
            }
            return Description.NO_MATCH;
        }
        TargetType target = TargetType.targetType((VisitorState)state.withPath(path));
        if (target == null) {
            return Description.NO_MATCH;
        }
        if (!UnnecessaryStringBuilder.isUsedAsStringBuilder(state, target)) {
            return this.describeMatch(path.getLeaf(), (Fix)SuggestedFix.replace((Tree)path.getLeaf(), (String)UnnecessaryStringBuilder.replacement(state, parts)));
        }
        Tree leaf = target.path().getLeaf();
        if (leaf instanceof VariableTree && this.isRewritableVariable(variableTree = (VariableTree)leaf, state)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            if (!ASTHelpers.hasImplicitType((VariableTree)variableTree, (VisitorState)state)) {
                fix.replace(variableTree.getType(), "String");
            }
            fix.replace((Tree)variableTree.getInitializer(), UnnecessaryStringBuilder.replacement(state, parts));
            return this.describeMatch(variableTree, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }

    boolean isRewritableVariable(VariableTree variableTree, final VisitorState state) {
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)variableTree);
        if (!((Symbol)sym).getKind().equals((Object)ElementKind.LOCAL_VARIABLE)) {
            return false;
        }
        final boolean[] ok = new boolean[]{true};
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ UnnecessaryStringBuilder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                TargetType target;
                if (sym.equals(ASTHelpers.getSymbol((Tree)tree)) && UnnecessaryStringBuilder.isUsedAsStringBuilder(state, target = TargetType.targetType((VisitorState)state.withPath(this.getCurrentPath())))) {
                    ok[0] = false;
                }
                return (Void)super.visitIdentifier(tree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return ok[0];
    }

    private static boolean isUsedAsStringBuilder(VisitorState state, TargetType target) {
        if (target.path().getLeaf() instanceof MemberReferenceTree) {
            return true;
        }
        return ASTHelpers.isSubtype((Type)target.type(), (Type)((Type)JAVA_LANG_APPENDABLE.get(state)), (VisitorState)state);
    }

    private static String replacement(VisitorState state, List<ExpressionTree> parts) {
        if (parts.isEmpty()) {
            return "\"\"";
        }
        return parts.stream().map(x -> {
            String source = state.getSourceForNode((Tree)x);
            if (ASTHelpers.requiresParentheses((ExpressionTree)x, (VisitorState)state)) {
                source = String.format("(%s)", source);
            }
            return source;
        }).collect(Collectors.joining(" + "));
    }
}

