/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

@BugPattern(summary="Thread.join needs to be immediately surrounded by a loop until it succeeds. Consider using Uninterruptibles.joinUninterruptibly.", severity=BugPattern.SeverityLevel.WARNING)
public class ThreadJoinLoop
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCH_THREAD_JOIN = Matchers.instanceMethod().onDescendantOf("java.lang.Thread").named("join");
    private static final Supplier<Type> JAVA_LANG_THREAD = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.Thread"));

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        TryTree tryTree;
        BlockTree blockTree;
        StatementTree statements;
        String threadString;
        ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
        if (expressionTree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)expressionTree;
            threadString = state.getSourceForNode((Tree)memberSelectTree.getExpression());
        } else {
            threadString = "this";
        }
        if (!methodInvocationTree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (!MATCH_THREAD_JOIN.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        TreePath tryTreePath = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)state.getPath(), TryTree.class);
        if (tryTreePath == null) {
            return Description.NO_MATCH;
        }
        WhileLoopTree pathToLoop = (WhileLoopTree)ASTHelpers.findEnclosingNode((TreePath)tryTreePath, WhileLoopTree.class);
        boolean hasWhileLoopOneStatement = false;
        if (pathToLoop != null && (statements = pathToLoop.getStatement()) instanceof BlockTree && (blockTree = (BlockTree)statements).getStatements().size() == 1) {
            hasWhileLoopOneStatement = true;
        }
        if (ThreadJoinLoop.hasOtherInvocationsOrAssignments(methodInvocationTree, tryTree = (TryTree)tryTreePath.getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        if (tryTree.getFinallyBlock() != null) {
            return Description.NO_MATCH;
        }
        Type interruptedType = state.getSymtab().interruptedExceptionType;
        for (CatchTree catchTree : tryTree.getCatches()) {
            Type typeSym = ASTHelpers.getType((Tree)catchTree.getParameter().getType());
            if (!ASTHelpers.isCastable((Type)typeSym, (Type)interruptedType, (VisitorState)state) || !catchTree.getBlock().getStatements().stream().allMatch(s -> s instanceof EmptyStatementTree)) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String uninterruptibles = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"com.google.common.util.concurrent.Uninterruptibles");
            fix.replace((Tree)(hasWhileLoopOneStatement ? pathToLoop : tryTree), String.format("%s.joinUninterruptibly(%s);", uninterruptibles, threadString));
            return this.describeMatch(methodInvocationTree, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }

    private static boolean hasOtherInvocationsOrAssignments(final MethodInvocationTree methodInvocationTree, TryTree tryTree, final VisitorState state) {
        final AtomicInteger count = new AtomicInteger(0);
        final Type threadType = (Type)JAVA_LANG_THREAD.get(state);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (!tree.equals(methodInvocationTree)) {
                    count.incrementAndGet();
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                if (ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)tree.getVariable()), (Type)threadType, (VisitorState)state)) {
                    count.incrementAndGet();
                }
                return (Void)super.visitAssignment(tree, null);
            }
        }.scan(tryTree.getBlock(), null);
        return count.get() > 0;
    }
}

