/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Context;
import java.util.regex.Pattern;

final class Switches {
    private static final Pattern SKEW_PATTERN = Pattern.compile("\\bskew\\b", 2);

    static boolean isDefaultCaseForSkew(SwitchTree switchTree, CaseTree defaultCase, VisitorState state) {
        int startPos;
        Preconditions.checkArgument((boolean)ASTHelpers.isSwitchDefault((CaseTree)defaultCase));
        int indexOfDefault = switchTree.getCases().indexOf(defaultCase);
        int n = startPos = indexOfDefault > 0 ? state.getEndPosition((Tree)switchTree.getCases().get(indexOfDefault - 1)) : state.getEndPosition((Tree)switchTree.getExpression());
        int endPos = defaultCase.getBody() != null ? ASTHelpers.getStartPosition((Tree)defaultCase.getBody()) : (!defaultCase.getStatements().isEmpty() ? ASTHelpers.getStartPosition((Tree)defaultCase.getStatements().get(0)) : (indexOfDefault + 1 < switchTree.getCases().size() ? ASTHelpers.getStartPosition((Tree)switchTree.getCases().get(indexOfDefault + 1)) : state.getEndPosition((Tree)switchTree)));
        ImmutableList tokens = ErrorProneTokens.getTokens((String)state.getSourceCode().subSequence(startPos, endPos).toString(), (int)startPos, (Context)state.context);
        return tokens.stream().flatMap(token -> token.comments().stream()).anyMatch(comment -> SKEW_PATTERN.matcher(comment.getText()).find());
    }

    static boolean isDefaultCaseForSkew(SwitchExpressionTree switchTree, CaseTree defaultCase, VisitorState state) {
        Preconditions.checkArgument((boolean)ASTHelpers.isSwitchDefault((CaseTree)defaultCase));
        int indexOfDefault = switchTree.getCases().indexOf(defaultCase);
        int startPos = indexOfDefault > 0 ? state.getEndPosition((Tree)switchTree.getCases().get(indexOfDefault - 1)) : state.getEndPosition((Tree)switchTree.getExpression());
        int endPos = ASTHelpers.getStartPosition((Tree)(switch (defaultCase.getCaseKind()) {
            default -> throw new IncompatibleClassChangeError();
            case CaseTree.CaseKind.STATEMENT -> defaultCase.getStatements().get(0);
            case CaseTree.CaseKind.RULE -> defaultCase.getBody();
        }));
        ImmutableList tokens = ErrorProneTokens.getTokens((String)state.getSourceCode().subSequence(startPos, endPos).toString(), (int)startPos, (Context)state.context);
        return tokens.stream().flatMap(token -> token.comments().stream()).anyMatch(comment -> SKEW_PATTERN.matcher(comment.getText()).find());
    }

    private Switches() {
    }
}

