/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="Usage of internal proprietary API which may be removed in a future release", severity=BugPattern.SeverityLevel.WARNING)
public class SunApi
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher,
BugChecker.IdentifierTreeMatcher {
    public Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    private Description match(Tree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (!SunApi.inJdkUnsupportedModule(sym) && (sym.flags() & 0x4000000000L) == 0L) {
            return Description.NO_MATCH;
        }
        if (state.findEnclosing(new Class[]{ImportTree.class}) != null) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("%s is an internal JDK API which may be removed in a future release", sym.getQualifiedName())).build();
    }

    private static boolean inJdkUnsupportedModule(Symbol sym) {
        Symbol.PackageSymbol packageSymbol = ASTHelpers.enclosingPackage((Symbol)sym);
        if (packageSymbol == null) {
            return false;
        }
        Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)packageSymbol.getEnclosingElement();
        if (moduleSymbol == null) {
            return false;
        }
        return moduleSymbol.name.contentEquals("jdk.unsupported");
    }
}

