/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReferenceEquality;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import javax.inject.Inject;

@BugPattern(summary="Comparison using reference equality instead of value equality. Reference equality of boxed primitive types is usually not useful, as they are value objects, and it is bug-prone, as instances are cached for some values but not others.", altNames={"NumericEquality"}, severity=BugPattern.SeverityLevel.ERROR)
public final class BoxedPrimitiveEquality
extends AbstractReferenceEquality {
    @Inject
    BoxedPrimitiveEquality() {
    }

    @Override
    protected boolean matchArgument(ExpressionTree tree, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        return type != null && this.isRelevantType(type, state);
    }

    private boolean isRelevantType(Type type, VisitorState state) {
        return !type.isPrimitive() && state.getTypes().unboxedType(type).isPrimitive();
    }
}

