// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/devtools/build/v1/publish_build_event.proto
// Protobuf Java Version: 4.33.0

package com.google.devtools.build.v1;

/**
 * <pre>
 * Publishes 'lifecycle events' that update the high-level state of a build:
 * - BuildEnqueued: When a build is scheduled.
 * - InvocationAttemptStarted: When work for a build starts; there can be
 * multiple invocations for a build (e.g. retries).
 * - InvocationAttemptCompleted: When work for a build finishes.
 * - BuildFinished: When a build is finished.
 * </pre>
 *
 * Protobuf type {@code google.devtools.build.v1.PublishLifecycleEventRequest}
 */
@com.google.protobuf.Generated
public final class PublishLifecycleEventRequest extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:google.devtools.build.v1.PublishLifecycleEventRequest)
    PublishLifecycleEventRequestOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 33,
      /* patch= */ 0,
      /* suffix= */ "",
      "PublishLifecycleEventRequest");
  }
  // Use PublishLifecycleEventRequest.newBuilder() to construct.
  private PublishLifecycleEventRequest(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private PublishLifecycleEventRequest() {
    serviceLevel_ = 0;
    notificationKeywords_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    projectId_ = "";
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.devtools.build.v1.BackendProto.internal_static_google_devtools_build_v1_PublishLifecycleEventRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.build.v1.BackendProto.internal_static_google_devtools_build_v1_PublishLifecycleEventRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.build.v1.PublishLifecycleEventRequest.class, com.google.devtools.build.v1.PublishLifecycleEventRequest.Builder.class);
  }

  /**
   * <pre>
   * The service level of the build request. Backends only uses this value when
   * the BuildEnqueued event is published to determine what level of service
   * this build should receive.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel}
   */
  public enum ServiceLevel
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Non-interactive builds can tolerate longer event latencies. This is the
     * default ServiceLevel if callers do not specify one.
     * </pre>
     *
     * <code>NONINTERACTIVE = 0;</code>
     */
    NONINTERACTIVE(0),
    /**
     * <pre>
     * The events of an interactive build should be delivered with low latency.
     * </pre>
     *
     * <code>INTERACTIVE = 1;</code>
     */
    INTERACTIVE(1),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 0,
        /* suffix= */ "",
        "ServiceLevel");
    }
    /**
     * <pre>
     * Non-interactive builds can tolerate longer event latencies. This is the
     * default ServiceLevel if callers do not specify one.
     * </pre>
     *
     * <code>NONINTERACTIVE = 0;</code>
     */
    public static final int NONINTERACTIVE_VALUE = 0;
    /**
     * <pre>
     * The events of an interactive build should be delivered with low latency.
     * </pre>
     *
     * <code>INTERACTIVE = 1;</code>
     */
    public static final int INTERACTIVE_VALUE = 1;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ServiceLevel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ServiceLevel forNumber(int value) {
      switch (value) {
        case 0: return NONINTERACTIVE;
        case 1: return INTERACTIVE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ServiceLevel>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ServiceLevel> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ServiceLevel>() {
            public ServiceLevel findValueByNumber(int number) {
              return ServiceLevel.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.devtools.build.v1.PublishLifecycleEventRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final ServiceLevel[] VALUES = values();

    public static ServiceLevel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ServiceLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel)
  }

  private int bitField0_;
  public static final int SERVICE_LEVEL_FIELD_NUMBER = 1;
  private int serviceLevel_ = 0;
  /**
   * <pre>
   * The interactivity of this build.
   * </pre>
   *
   * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
   * @return The enum numeric value on the wire for serviceLevel.
   */
  @java.lang.Override public int getServiceLevelValue() {
    return serviceLevel_;
  }
  /**
   * <pre>
   * The interactivity of this build.
   * </pre>
   *
   * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
   * @return The serviceLevel.
   */
  @java.lang.Override public com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel getServiceLevel() {
    com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel result = com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.forNumber(serviceLevel_);
    return result == null ? com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.UNRECOGNIZED : result;
  }

  public static final int BUILD_EVENT_FIELD_NUMBER = 2;
  private com.google.devtools.build.v1.OrderedBuildEvent buildEvent_;
  /**
   * <pre>
   * Required. The lifecycle build event. If this is a build tool event, the RPC
   * will fail with INVALID_REQUEST.
   * </pre>
   *
   * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return Whether the buildEvent field is set.
   */
  @java.lang.Override
  public boolean hasBuildEvent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Required. The lifecycle build event. If this is a build tool event, the RPC
   * will fail with INVALID_REQUEST.
   * </pre>
   *
   * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The buildEvent.
   */
  @java.lang.Override
  public com.google.devtools.build.v1.OrderedBuildEvent getBuildEvent() {
    return buildEvent_ == null ? com.google.devtools.build.v1.OrderedBuildEvent.getDefaultInstance() : buildEvent_;
  }
  /**
   * <pre>
   * Required. The lifecycle build event. If this is a build tool event, the RPC
   * will fail with INVALID_REQUEST.
   * </pre>
   *
   * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.devtools.build.v1.OrderedBuildEventOrBuilder getBuildEventOrBuilder() {
    return buildEvent_ == null ? com.google.devtools.build.v1.OrderedBuildEvent.getDefaultInstance() : buildEvent_;
  }

  public static final int STREAM_TIMEOUT_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration streamTimeout_;
  /**
   * <pre>
   * If the next event for this build or invocation (depending on the event
   * type) hasn't been published after this duration from when {build_event}
   * is written to BES, consider this stream expired. If this field is not set,
   * BES backend will use its own default value.
   * </pre>
   *
   * <code>.google.protobuf.Duration stream_timeout = 3;</code>
   * @return Whether the streamTimeout field is set.
   */
  @java.lang.Override
  public boolean hasStreamTimeout() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * If the next event for this build or invocation (depending on the event
   * type) hasn't been published after this duration from when {build_event}
   * is written to BES, consider this stream expired. If this field is not set,
   * BES backend will use its own default value.
   * </pre>
   *
   * <code>.google.protobuf.Duration stream_timeout = 3;</code>
   * @return The streamTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getStreamTimeout() {
    return streamTimeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : streamTimeout_;
  }
  /**
   * <pre>
   * If the next event for this build or invocation (depending on the event
   * type) hasn't been published after this duration from when {build_event}
   * is written to BES, consider this stream expired. If this field is not set,
   * BES backend will use its own default value.
   * </pre>
   *
   * <code>.google.protobuf.Duration stream_timeout = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getStreamTimeoutOrBuilder() {
    return streamTimeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : streamTimeout_;
  }

  public static final int NOTIFICATION_KEYWORDS_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList notificationKeywords_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Additional information about a build request. These are define by the event
   * publishers, and the Build Event Service does not validate or interpret
   * them. They are used while notifying internal systems of new builds and
   * invocations if the OrderedBuildEvent.event type is
   * BuildEnqueued/InvocationAttemptStarted.
   * </pre>
   *
   * <code>repeated string notification_keywords = 4;</code>
   * @return A list containing the notificationKeywords.
   */
  public com.google.protobuf.ProtocolStringList
      getNotificationKeywordsList() {
    return notificationKeywords_;
  }
  /**
   * <pre>
   * Additional information about a build request. These are define by the event
   * publishers, and the Build Event Service does not validate or interpret
   * them. They are used while notifying internal systems of new builds and
   * invocations if the OrderedBuildEvent.event type is
   * BuildEnqueued/InvocationAttemptStarted.
   * </pre>
   *
   * <code>repeated string notification_keywords = 4;</code>
   * @return The count of notificationKeywords.
   */
  public int getNotificationKeywordsCount() {
    return notificationKeywords_.size();
  }
  /**
   * <pre>
   * Additional information about a build request. These are define by the event
   * publishers, and the Build Event Service does not validate or interpret
   * them. They are used while notifying internal systems of new builds and
   * invocations if the OrderedBuildEvent.event type is
   * BuildEnqueued/InvocationAttemptStarted.
   * </pre>
   *
   * <code>repeated string notification_keywords = 4;</code>
   * @param index The index of the element to return.
   * @return The notificationKeywords at the given index.
   */
  public java.lang.String getNotificationKeywords(int index) {
    return notificationKeywords_.get(index);
  }
  /**
   * <pre>
   * Additional information about a build request. These are define by the event
   * publishers, and the Build Event Service does not validate or interpret
   * them. They are used while notifying internal systems of new builds and
   * invocations if the OrderedBuildEvent.event type is
   * BuildEnqueued/InvocationAttemptStarted.
   * </pre>
   *
   * <code>repeated string notification_keywords = 4;</code>
   * @param index The index of the value to return.
   * @return The bytes of the notificationKeywords at the given index.
   */
  public com.google.protobuf.ByteString
      getNotificationKeywordsBytes(int index) {
    return notificationKeywords_.getByteString(index);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   * <pre>
   * Required. The project this build is associated with.
   * This should match the project used for the initial call to
   * PublishLifecycleEvent (containing a BuildEnqueued message).
   * </pre>
   *
   * <code>string project_id = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Required. The project this build is associated with.
   * This should match the project used for the initial call to
   * PublishLifecycleEvent (containing a BuildEnqueued message).
   * </pre>
   *
   * <code>string project_id = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHECK_PRECEDING_LIFECYCLE_EVENTS_PRESENT_FIELD_NUMBER = 7;
  private boolean checkPrecedingLifecycleEventsPresent_ = false;
  /**
   * <pre>
   * Whether to require a previously received matching parent lifecycle event
   * for the current request's event before continuing processing.
   * - InvocationAttemptStarted and BuildFinished events require a BuildEnqueued
   * parent event.
   * - InvocationAttemptFinished events require an InvocationAttemptStarted
   * parent event.
   * </pre>
   *
   * <code>bool check_preceding_lifecycle_events_present = 7;</code>
   * @return The checkPrecedingLifecycleEventsPresent.
   */
  @java.lang.Override
  public boolean getCheckPrecedingLifecycleEventsPresent() {
    return checkPrecedingLifecycleEventsPresent_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (serviceLevel_ != com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.NONINTERACTIVE.getNumber()) {
      output.writeEnum(1, serviceLevel_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getBuildEvent());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getStreamTimeout());
    }
    for (int i = 0; i < notificationKeywords_.size(); i++) {
      com.google.protobuf.GeneratedMessage.writeString(output, 4, notificationKeywords_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 6, projectId_);
    }
    if (checkPrecedingLifecycleEventsPresent_ != false) {
      output.writeBool(7, checkPrecedingLifecycleEventsPresent_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (serviceLevel_ != com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.NONINTERACTIVE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, serviceLevel_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getBuildEvent());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getStreamTimeout());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < notificationKeywords_.size(); i++) {
        dataSize += computeStringSizeNoTag(notificationKeywords_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNotificationKeywordsList().size();
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(6, projectId_);
    }
    if (checkPrecedingLifecycleEventsPresent_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(7, checkPrecedingLifecycleEventsPresent_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.devtools.build.v1.PublishLifecycleEventRequest)) {
      return super.equals(obj);
    }
    com.google.devtools.build.v1.PublishLifecycleEventRequest other = (com.google.devtools.build.v1.PublishLifecycleEventRequest) obj;

    if (serviceLevel_ != other.serviceLevel_) return false;
    if (hasBuildEvent() != other.hasBuildEvent()) return false;
    if (hasBuildEvent()) {
      if (!getBuildEvent()
          .equals(other.getBuildEvent())) return false;
    }
    if (hasStreamTimeout() != other.hasStreamTimeout()) return false;
    if (hasStreamTimeout()) {
      if (!getStreamTimeout()
          .equals(other.getStreamTimeout())) return false;
    }
    if (!getNotificationKeywordsList()
        .equals(other.getNotificationKeywordsList())) return false;
    if (!getProjectId()
        .equals(other.getProjectId())) return false;
    if (getCheckPrecedingLifecycleEventsPresent()
        != other.getCheckPrecedingLifecycleEventsPresent()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + serviceLevel_;
    if (hasBuildEvent()) {
      hash = (37 * hash) + BUILD_EVENT_FIELD_NUMBER;
      hash = (53 * hash) + getBuildEvent().hashCode();
    }
    if (hasStreamTimeout()) {
      hash = (37 * hash) + STREAM_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getStreamTimeout().hashCode();
    }
    if (getNotificationKeywordsCount() > 0) {
      hash = (37 * hash) + NOTIFICATION_KEYWORDS_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationKeywordsList().hashCode();
    }
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + CHECK_PRECEDING_LIFECYCLE_EVENTS_PRESENT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getCheckPrecedingLifecycleEventsPresent());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.devtools.build.v1.PublishLifecycleEventRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Publishes 'lifecycle events' that update the high-level state of a build:
   * - BuildEnqueued: When a build is scheduled.
   * - InvocationAttemptStarted: When work for a build starts; there can be
   * multiple invocations for a build (e.g. retries).
   * - InvocationAttemptCompleted: When work for a build finishes.
   * - BuildFinished: When a build is finished.
   * </pre>
   *
   * Protobuf type {@code google.devtools.build.v1.PublishLifecycleEventRequest}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.devtools.build.v1.PublishLifecycleEventRequest)
      com.google.devtools.build.v1.PublishLifecycleEventRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.devtools.build.v1.BackendProto.internal_static_google_devtools_build_v1_PublishLifecycleEventRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.build.v1.BackendProto.internal_static_google_devtools_build_v1_PublishLifecycleEventRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.build.v1.PublishLifecycleEventRequest.class, com.google.devtools.build.v1.PublishLifecycleEventRequest.Builder.class);
    }

    // Construct using com.google.devtools.build.v1.PublishLifecycleEventRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage
              .alwaysUseFieldBuilders) {
        internalGetBuildEventFieldBuilder();
        internalGetStreamTimeoutFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      serviceLevel_ = 0;
      buildEvent_ = null;
      if (buildEventBuilder_ != null) {
        buildEventBuilder_.dispose();
        buildEventBuilder_ = null;
      }
      streamTimeout_ = null;
      if (streamTimeoutBuilder_ != null) {
        streamTimeoutBuilder_.dispose();
        streamTimeoutBuilder_ = null;
      }
      notificationKeywords_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      projectId_ = "";
      checkPrecedingLifecycleEventsPresent_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.devtools.build.v1.BackendProto.internal_static_google_devtools_build_v1_PublishLifecycleEventRequest_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.build.v1.PublishLifecycleEventRequest getDefaultInstanceForType() {
      return com.google.devtools.build.v1.PublishLifecycleEventRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.build.v1.PublishLifecycleEventRequest build() {
      com.google.devtools.build.v1.PublishLifecycleEventRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.build.v1.PublishLifecycleEventRequest buildPartial() {
      com.google.devtools.build.v1.PublishLifecycleEventRequest result = new com.google.devtools.build.v1.PublishLifecycleEventRequest(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.devtools.build.v1.PublishLifecycleEventRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.serviceLevel_ = serviceLevel_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.buildEvent_ = buildEventBuilder_ == null
            ? buildEvent_
            : buildEventBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.streamTimeout_ = streamTimeoutBuilder_ == null
            ? streamTimeout_
            : streamTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        notificationKeywords_.makeImmutable();
        result.notificationKeywords_ = notificationKeywords_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.checkPrecedingLifecycleEventsPresent_ = checkPrecedingLifecycleEventsPresent_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.build.v1.PublishLifecycleEventRequest) {
        return mergeFrom((com.google.devtools.build.v1.PublishLifecycleEventRequest)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.build.v1.PublishLifecycleEventRequest other) {
      if (other == com.google.devtools.build.v1.PublishLifecycleEventRequest.getDefaultInstance()) return this;
      if (other.serviceLevel_ != 0) {
        setServiceLevelValue(other.getServiceLevelValue());
      }
      if (other.hasBuildEvent()) {
        mergeBuildEvent(other.getBuildEvent());
      }
      if (other.hasStreamTimeout()) {
        mergeStreamTimeout(other.getStreamTimeout());
      }
      if (!other.notificationKeywords_.isEmpty()) {
        if (notificationKeywords_.isEmpty()) {
          notificationKeywords_ = other.notificationKeywords_;
          bitField0_ |= 0x00000008;
        } else {
          ensureNotificationKeywordsIsMutable();
          notificationKeywords_.addAll(other.notificationKeywords_);
        }
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getCheckPrecedingLifecycleEventsPresent() != false) {
        setCheckPrecedingLifecycleEventsPresent(other.getCheckPrecedingLifecycleEventsPresent());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              serviceLevel_ = input.readEnum();
              bitField0_ |= 0x00000001;
              break;
            } // case 8
            case 18: {
              input.readMessage(
                  internalGetBuildEventFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000002;
              break;
            } // case 18
            case 26: {
              input.readMessage(
                  internalGetStreamTimeoutFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000004;
              break;
            } // case 26
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureNotificationKeywordsIsMutable();
              notificationKeywords_.add(s);
              break;
            } // case 34
            case 50: {
              projectId_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000010;
              break;
            } // case 50
            case 56: {
              checkPrecedingLifecycleEventsPresent_ = input.readBool();
              bitField0_ |= 0x00000020;
              break;
            } // case 56
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private int serviceLevel_ = 0;
    /**
     * <pre>
     * The interactivity of this build.
     * </pre>
     *
     * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
     * @return The enum numeric value on the wire for serviceLevel.
     */
    @java.lang.Override public int getServiceLevelValue() {
      return serviceLevel_;
    }
    /**
     * <pre>
     * The interactivity of this build.
     * </pre>
     *
     * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
     * @param value The enum numeric value on the wire for serviceLevel to set.
     * @return This builder for chaining.
     */
    public Builder setServiceLevelValue(int value) {
      serviceLevel_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The interactivity of this build.
     * </pre>
     *
     * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
     * @return The serviceLevel.
     */
    @java.lang.Override
    public com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel getServiceLevel() {
      com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel result = com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.forNumber(serviceLevel_);
      return result == null ? com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The interactivity of this build.
     * </pre>
     *
     * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
     * @param value The serviceLevel to set.
     * @return This builder for chaining.
     */
    public Builder setServiceLevel(com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel value) {
      if (value == null) { throw new NullPointerException(); }
      bitField0_ |= 0x00000001;
      serviceLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The interactivity of this build.
     * </pre>
     *
     * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearServiceLevel() {
      bitField0_ = (bitField0_ & ~0x00000001);
      serviceLevel_ = 0;
      onChanged();
      return this;
    }

    private com.google.devtools.build.v1.OrderedBuildEvent buildEvent_;
    private com.google.protobuf.SingleFieldBuilder<
        com.google.devtools.build.v1.OrderedBuildEvent, com.google.devtools.build.v1.OrderedBuildEvent.Builder, com.google.devtools.build.v1.OrderedBuildEventOrBuilder> buildEventBuilder_;
    /**
     * <pre>
     * Required. The lifecycle build event. If this is a build tool event, the RPC
     * will fail with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return Whether the buildEvent field is set.
     */
    public boolean hasBuildEvent() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Required. The lifecycle build event. If this is a build tool event, the RPC
     * will fail with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The buildEvent.
     */
    public com.google.devtools.build.v1.OrderedBuildEvent getBuildEvent() {
      if (buildEventBuilder_ == null) {
        return buildEvent_ == null ? com.google.devtools.build.v1.OrderedBuildEvent.getDefaultInstance() : buildEvent_;
      } else {
        return buildEventBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Required. The lifecycle build event. If this is a build tool event, the RPC
     * will fail with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setBuildEvent(com.google.devtools.build.v1.OrderedBuildEvent value) {
      if (buildEventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        buildEvent_ = value;
      } else {
        buildEventBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The lifecycle build event. If this is a build tool event, the RPC
     * will fail with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setBuildEvent(
        com.google.devtools.build.v1.OrderedBuildEvent.Builder builderForValue) {
      if (buildEventBuilder_ == null) {
        buildEvent_ = builderForValue.build();
      } else {
        buildEventBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The lifecycle build event. If this is a build tool event, the RPC
     * will fail with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeBuildEvent(com.google.devtools.build.v1.OrderedBuildEvent value) {
      if (buildEventBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0) &&
          buildEvent_ != null &&
          buildEvent_ != com.google.devtools.build.v1.OrderedBuildEvent.getDefaultInstance()) {
          getBuildEventBuilder().mergeFrom(value);
        } else {
          buildEvent_ = value;
        }
      } else {
        buildEventBuilder_.mergeFrom(value);
      }
      if (buildEvent_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Required. The lifecycle build event. If this is a build tool event, the RPC
     * will fail with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearBuildEvent() {
      bitField0_ = (bitField0_ & ~0x00000002);
      buildEvent_ = null;
      if (buildEventBuilder_ != null) {
        buildEventBuilder_.dispose();
        buildEventBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The lifecycle build event. If this is a build tool event, the RPC
     * will fail with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.devtools.build.v1.OrderedBuildEvent.Builder getBuildEventBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return internalGetBuildEventFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Required. The lifecycle build event. If this is a build tool event, the RPC
     * will fail with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.devtools.build.v1.OrderedBuildEventOrBuilder getBuildEventOrBuilder() {
      if (buildEventBuilder_ != null) {
        return buildEventBuilder_.getMessageOrBuilder();
      } else {
        return buildEvent_ == null ?
            com.google.devtools.build.v1.OrderedBuildEvent.getDefaultInstance() : buildEvent_;
      }
    }
    /**
     * <pre>
     * Required. The lifecycle build event. If this is a build tool event, the RPC
     * will fail with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.devtools.build.v1.OrderedBuildEvent, com.google.devtools.build.v1.OrderedBuildEvent.Builder, com.google.devtools.build.v1.OrderedBuildEventOrBuilder> 
        internalGetBuildEventFieldBuilder() {
      if (buildEventBuilder_ == null) {
        buildEventBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.devtools.build.v1.OrderedBuildEvent, com.google.devtools.build.v1.OrderedBuildEvent.Builder, com.google.devtools.build.v1.OrderedBuildEventOrBuilder>(
                getBuildEvent(),
                getParentForChildren(),
                isClean());
        buildEvent_ = null;
      }
      return buildEventBuilder_;
    }

    private com.google.protobuf.Duration streamTimeout_;
    private com.google.protobuf.SingleFieldBuilder<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> streamTimeoutBuilder_;
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     * @return Whether the streamTimeout field is set.
     */
    public boolean hasStreamTimeout() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     * @return The streamTimeout.
     */
    public com.google.protobuf.Duration getStreamTimeout() {
      if (streamTimeoutBuilder_ == null) {
        return streamTimeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : streamTimeout_;
      } else {
        return streamTimeoutBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public Builder setStreamTimeout(com.google.protobuf.Duration value) {
      if (streamTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamTimeout_ = value;
      } else {
        streamTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public Builder setStreamTimeout(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (streamTimeoutBuilder_ == null) {
        streamTimeout_ = builderForValue.build();
      } else {
        streamTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public Builder mergeStreamTimeout(com.google.protobuf.Duration value) {
      if (streamTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0) &&
          streamTimeout_ != null &&
          streamTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getStreamTimeoutBuilder().mergeFrom(value);
        } else {
          streamTimeout_ = value;
        }
      } else {
        streamTimeoutBuilder_.mergeFrom(value);
      }
      if (streamTimeout_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public Builder clearStreamTimeout() {
      bitField0_ = (bitField0_ & ~0x00000004);
      streamTimeout_ = null;
      if (streamTimeoutBuilder_ != null) {
        streamTimeoutBuilder_.dispose();
        streamTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getStreamTimeoutBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return internalGetStreamTimeoutFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getStreamTimeoutOrBuilder() {
      if (streamTimeoutBuilder_ != null) {
        return streamTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return streamTimeout_ == null ?
            com.google.protobuf.Duration.getDefaultInstance() : streamTimeout_;
      }
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> 
        internalGetStreamTimeoutFieldBuilder() {
      if (streamTimeoutBuilder_ == null) {
        streamTimeoutBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder>(
                getStreamTimeout(),
                getParentForChildren(),
                isClean());
        streamTimeout_ = null;
      }
      return streamTimeoutBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList notificationKeywords_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureNotificationKeywordsIsMutable() {
      if (!notificationKeywords_.isModifiable()) {
        notificationKeywords_ = new com.google.protobuf.LazyStringArrayList(notificationKeywords_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     * @return A list containing the notificationKeywords.
     */
    public com.google.protobuf.ProtocolStringList
        getNotificationKeywordsList() {
      notificationKeywords_.makeImmutable();
      return notificationKeywords_;
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     * @return The count of notificationKeywords.
     */
    public int getNotificationKeywordsCount() {
      return notificationKeywords_.size();
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     * @param index The index of the element to return.
     * @return The notificationKeywords at the given index.
     */
    public java.lang.String getNotificationKeywords(int index) {
      return notificationKeywords_.get(index);
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     * @param index The index of the value to return.
     * @return The bytes of the notificationKeywords at the given index.
     */
    public com.google.protobuf.ByteString
        getNotificationKeywordsBytes(int index) {
      return notificationKeywords_.getByteString(index);
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     * @param index The index to set the value at.
     * @param value The notificationKeywords to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationKeywords(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureNotificationKeywordsIsMutable();
      notificationKeywords_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     * @param value The notificationKeywords to add.
     * @return This builder for chaining.
     */
    public Builder addNotificationKeywords(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureNotificationKeywordsIsMutable();
      notificationKeywords_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     * @param values The notificationKeywords to add.
     * @return This builder for chaining.
     */
    public Builder addAllNotificationKeywords(
        java.lang.Iterable<java.lang.String> values) {
      ensureNotificationKeywordsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, notificationKeywords_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearNotificationKeywords() {
      notificationKeywords_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     * @param value The bytes of the notificationKeywords to add.
     * @return This builder for chaining.
     */
    public Builder addNotificationKeywordsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureNotificationKeywordsIsMutable();
      notificationKeywords_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     * <pre>
     * Required. The project this build is associated with.
     * This should match the project used for the initial call to
     * PublishLifecycleEvent (containing a BuildEnqueued message).
     * </pre>
     *
     * <code>string project_id = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Required. The project this build is associated with.
     * This should match the project used for the initial call to
     * PublishLifecycleEvent (containing a BuildEnqueued message).
     * </pre>
     *
     * <code>string project_id = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString
        getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Required. The project this build is associated with.
     * This should match the project used for the initial call to
     * PublishLifecycleEvent (containing a BuildEnqueued message).
     * </pre>
     *
     * <code>string project_id = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      projectId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The project this build is associated with.
     * This should match the project used for the initial call to
     * PublishLifecycleEvent (containing a BuildEnqueued message).
     * </pre>
     *
     * <code>string project_id = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The project this build is associated with.
     * This should match the project used for the initial call to
     * PublishLifecycleEvent (containing a BuildEnqueued message).
     * </pre>
     *
     * <code>string project_id = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean checkPrecedingLifecycleEventsPresent_ ;
    /**
     * <pre>
     * Whether to require a previously received matching parent lifecycle event
     * for the current request's event before continuing processing.
     * - InvocationAttemptStarted and BuildFinished events require a BuildEnqueued
     * parent event.
     * - InvocationAttemptFinished events require an InvocationAttemptStarted
     * parent event.
     * </pre>
     *
     * <code>bool check_preceding_lifecycle_events_present = 7;</code>
     * @return The checkPrecedingLifecycleEventsPresent.
     */
    @java.lang.Override
    public boolean getCheckPrecedingLifecycleEventsPresent() {
      return checkPrecedingLifecycleEventsPresent_;
    }
    /**
     * <pre>
     * Whether to require a previously received matching parent lifecycle event
     * for the current request's event before continuing processing.
     * - InvocationAttemptStarted and BuildFinished events require a BuildEnqueued
     * parent event.
     * - InvocationAttemptFinished events require an InvocationAttemptStarted
     * parent event.
     * </pre>
     *
     * <code>bool check_preceding_lifecycle_events_present = 7;</code>
     * @param value The checkPrecedingLifecycleEventsPresent to set.
     * @return This builder for chaining.
     */
    public Builder setCheckPrecedingLifecycleEventsPresent(boolean value) {

      checkPrecedingLifecycleEventsPresent_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether to require a previously received matching parent lifecycle event
     * for the current request's event before continuing processing.
     * - InvocationAttemptStarted and BuildFinished events require a BuildEnqueued
     * parent event.
     * - InvocationAttemptFinished events require an InvocationAttemptStarted
     * parent event.
     * </pre>
     *
     * <code>bool check_preceding_lifecycle_events_present = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearCheckPrecedingLifecycleEventsPresent() {
      bitField0_ = (bitField0_ & ~0x00000020);
      checkPrecedingLifecycleEventsPresent_ = false;
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.build.v1.PublishLifecycleEventRequest)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.build.v1.PublishLifecycleEventRequest)
  private static final com.google.devtools.build.v1.PublishLifecycleEventRequest DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.devtools.build.v1.PublishLifecycleEventRequest();
  }

  public static com.google.devtools.build.v1.PublishLifecycleEventRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PublishLifecycleEventRequest>
      PARSER = new com.google.protobuf.AbstractParser<PublishLifecycleEventRequest>() {
    @java.lang.Override
    public PublishLifecycleEventRequest parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<PublishLifecycleEventRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PublishLifecycleEventRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.build.v1.PublishLifecycleEventRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

