/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;

public final class ErrorProneLog {
    private static final Constructor<Log.DiscardDiagnosticHandler> DISCARD_DIAGNOSTIC_HANDLER_CONSTRUCTOR = ErrorProneLog.getDiscardDiagnosticHandlerConstructor();
    private static final Constructor<Log.DeferredDiagnosticHandler> DEFERRED_DIAGNOSTIC_HANDLER_CONSTRUCTOR = ErrorProneLog.getDeferredDiagnosticHandlerConstructor();
    private static final Method GET_DIAGNOSTICS = ErrorProneLog.getGetDiagnosticsMethod();

    private static Constructor<Log.DiscardDiagnosticHandler> getDiscardDiagnosticHandlerConstructor() {
        try {
            return Log.DiscardDiagnosticHandler.class.getConstructor(Log.class);
        }
        catch (NoSuchMethodException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    public static Log.DiagnosticHandler discardDiagnosticHandler(Log log) {
        try {
            return DISCARD_DIAGNOSTIC_HANDLER_CONSTRUCTOR.newInstance(log);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static Constructor<Log.DeferredDiagnosticHandler> getDeferredDiagnosticHandlerConstructor() {
        try {
            return Log.DeferredDiagnosticHandler.class.getConstructor(Log.class);
        }
        catch (NoSuchMethodException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    public static Log.DeferredDiagnosticHandler deferredDiagnosticHandler(Log log) {
        try {
            return DEFERRED_DIAGNOSTIC_HANDLER_CONSTRUCTOR.newInstance(log);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static Method getGetDiagnosticsMethod() {
        try {
            return Log.DeferredDiagnosticHandler.class.getMethod("getDiagnostics", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    public static Collection<JCDiagnostic> getDiagnostics(Log.DeferredDiagnosticHandler diagnostics) {
        try {
            return (Collection)GET_DIAGNOSTICS.invoke((Object)diagnostics, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private ErrorProneLog() {
    }
}

