/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.dataflow.AutoValue_DataFlow_AnalysisParams;
import com.google.errorprone.dataflow.AutoValue_DataFlow_CfgParams;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import javax.annotation.processing.ProcessingEnvironment;
import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;
import org.checkerframework.errorprone.dataflow.analysis.Analysis;
import org.checkerframework.errorprone.dataflow.analysis.ForwardAnalysisImpl;
import org.checkerframework.errorprone.dataflow.analysis.ForwardTransferFunction;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.analysis.TransferFunction;
import org.checkerframework.errorprone.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.errorprone.dataflow.cfg.UnderlyingAST;
import org.checkerframework.errorprone.dataflow.cfg.builder.CFGBuilder;
import org.jspecify.annotations.Nullable;

public final class DataFlow {
    private static final LoadingCache<AnalysisParams, Analysis<?, ?, ?>> analysisCache = Caffeine.newBuilder().build(new CacheLoader<AnalysisParams, Analysis<?, ?, ?>>(){

        public Analysis<?, ?, ?> load(AnalysisParams key) {
            ControlFlowGraph cfg = key.cfg();
            ForwardTransferFunction<?, ?> transfer = key.transferFunction();
            ForwardAnalysisImpl analysis = new ForwardAnalysisImpl(transfer);
            analysis.performAnalysis(cfg);
            return analysis;
        }
    });
    private static final LoadingCache<CfgParams, ControlFlowGraph> cfgCache = Caffeine.newBuilder().maximumSize(1L).build((CacheLoader)new CacheLoader<CfgParams, ControlFlowGraph>(){

        public ControlFlowGraph load(CfgParams key) {
            UnderlyingAST.CFGLambda ast;
            Tree tree;
            TreePath methodPath = key.methodPath();
            ClassTree classTree = null;
            MethodTree methodTree = null;
            for (Tree parent : methodPath) {
                ClassTree c;
                if (parent instanceof MethodTree) {
                    MethodTree m;
                    methodTree = m = (MethodTree)parent;
                }
                if (!(parent instanceof ClassTree)) continue;
                classTree = c = (ClassTree)parent;
                break;
            }
            if ((tree = methodPath.getLeaf()) instanceof LambdaExpressionTree) {
                LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree;
                ast = new UnderlyingAST.CFGLambda(lambdaExpressionTree, classTree, methodTree);
            } else {
                tree = methodPath.getLeaf();
                if (tree instanceof MethodTree) {
                    MethodTree mt;
                    methodTree = mt = (MethodTree)tree;
                    ast = new UnderlyingAST.CFGMethod(methodTree, classTree);
                } else {
                    ast = new UnderlyingAST.CFGStatement(methodPath.getLeaf(), classTree);
                }
            }
            ProcessingEnvironment env = key.environment();
            analysisCache.invalidateAll();
            CompilationUnitTree root = methodPath.getCompilationUnit();
            return CFGBuilder.build((CompilationUnitTree)root, (UnderlyingAST)ast, (boolean)false, (boolean)false, (ProcessingEnvironment)env);
        }
    });

    private static @Nullable TreePath findEnclosingMethodOrLambdaOrInitializer(TreePath path) {
        while (path != null) {
            if (path.getLeaf() instanceof MethodTree) {
                return path;
            }
            TreePath parent = path.getParentPath();
            if (parent != null) {
                if (parent.getLeaf() instanceof ClassTree) {
                    if (path.getLeaf() instanceof BlockTree) {
                        return path;
                    }
                    if (path.getLeaf() instanceof VariableTree && ((VariableTree)path.getLeaf()).getInitializer() != null) {
                        return path;
                    }
                }
                if (parent.getLeaf() instanceof LambdaExpressionTree) {
                    return parent;
                }
            }
            path = parent;
        }
        return null;
    }

    private static <A extends AbstractValue<A>, S extends Store<S>, T extends ForwardTransferFunction<A, S>> Result<A, S, T> methodDataflow(TreePath methodPath, Context context, T transfer) {
        JavacProcessingEnvironment env = JavacProcessingEnvironment.instance(context);
        final ControlFlowGraph cfg = (ControlFlowGraph)cfgCache.get((Object)CfgParams.create(methodPath, env));
        AnalysisParams aparams = AnalysisParams.create(transfer, cfg, env);
        final Analysis analysis = (Analysis)analysisCache.get((Object)aparams);
        return new Result<A, S, T>(){

            @Override
            public Analysis<A, S, T> getAnalysis() {
                return analysis;
            }

            @Override
            public ControlFlowGraph getControlFlowGraph() {
                return cfg;
            }
        };
    }

    public static <A extends AbstractValue<A>, S extends Store<S>, T extends ForwardTransferFunction<A, S>> @Nullable A expressionDataflow(TreePath exprPath, Context context, T transfer) {
        MethodTree methodTree;
        Tree leaf = exprPath.getLeaf();
        Preconditions.checkArgument((boolean)(leaf instanceof ExpressionTree), (String)"Leaf of exprPath must be of type ExpressionTree, but was %s", (Object)leaf.getClass().getName());
        ExpressionTree expr = (ExpressionTree)leaf;
        TreePath enclosingMethodPath = DataFlow.findEnclosingMethodOrLambdaOrInitializer(exprPath);
        if (enclosingMethodPath == null) {
            return null;
        }
        Tree method = enclosingMethodPath.getLeaf();
        if (method instanceof MethodTree && (methodTree = (MethodTree)method).getBody() == null) {
            return null;
        }
        return (A)DataFlow.methodDataflow(enclosingMethodPath, context, transfer).getAnalysis().getValue((Tree)expr);
    }

    private DataFlow() {
    }

    @AutoValue
    static abstract class CfgParams {
        private ProcessingEnvironment environment;

        CfgParams() {
        }

        abstract TreePath methodPath();

        private static CfgParams create(TreePath methodPath, ProcessingEnvironment environment) {
            AutoValue_DataFlow_CfgParams cp = new AutoValue_DataFlow_CfgParams(methodPath);
            cp.environment = environment;
            return cp;
        }

        ProcessingEnvironment environment() {
            return this.environment;
        }
    }

    @AutoValue
    static abstract class AnalysisParams {
        private ProcessingEnvironment environment;

        AnalysisParams() {
        }

        abstract ForwardTransferFunction<?, ?> transferFunction();

        abstract ControlFlowGraph cfg();

        private static AnalysisParams create(ForwardTransferFunction<?, ?> transferFunction, ControlFlowGraph cfg, ProcessingEnvironment environment) {
            AutoValue_DataFlow_AnalysisParams ap = new AutoValue_DataFlow_AnalysisParams(transferFunction, cfg);
            ap.environment = environment;
            return ap;
        }

        ProcessingEnvironment environment() {
            return this.environment;
        }
    }

    public static interface Result<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> {
        public Analysis<A, S, T> getAnalysis();

        public ControlFlowGraph getControlFlowGraph();
    }
}

