/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.apply.ImportOrganizer;
import com.google.errorprone.apply.StaticOrder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class BasicImportOrganizer
implements ImportOrganizer {
    private final StaticOrder order;

    BasicImportOrganizer(StaticOrder order) {
        this.order = order;
    }

    @Override
    public ImportOrganizer.OrganizedImports organizeImports(List<ImportOrganizer.Import> imports) {
        Map partionedByStatic = imports.stream().collect(Collectors.partitioningBy(ImportOrganizer.Import::isStatic, ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(ImportOrganizer.Import::getType))));
        return new ImportOrganizer.OrganizedImports().addGroups(partionedByStatic, this.order.groupOrder());
    }
}

