/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.options;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.turbine.options.AutoValue_TurbineOptions;
import com.google.turbine.options.LanguageVersion;
import java.util.Optional;

@AutoValue
public abstract class TurbineOptions {
    public abstract ImmutableList<String> sources();

    public abstract ImmutableList<String> classPath();

    public abstract ImmutableSet<String> bootClassPath();

    public abstract LanguageVersion languageVersion();

    public abstract Optional<String> system();

    public abstract Optional<String> output();

    public abstract Optional<String> headerCompilationOutput();

    public abstract ImmutableList<String> processorPath();

    public abstract ImmutableSet<String> processors();

    public abstract ImmutableSet<String> builtinProcessors();

    public abstract ImmutableList<String> sourceJars();

    public abstract Optional<String> outputDeps();

    public abstract Optional<String> outputManifest();

    public abstract ImmutableSet<String> directJars();

    public abstract Optional<String> targetLabel();

    public abstract Optional<String> injectingRuleKind();

    public abstract ImmutableList<String> depsArtifacts();

    public abstract boolean help();

    public abstract ImmutableList<String> javacOpts();

    public abstract ReducedClasspathMode reducedClasspathMode();

    public abstract Optional<String> profile();

    public abstract Optional<String> gensrcOutput();

    public abstract Optional<String> resourceOutput();

    public abstract int fullClasspathLength();

    public abstract int reducedClasspathLength();

    public static Builder builder() {
        return new AutoValue_TurbineOptions.Builder().setSources((ImmutableList<String>)ImmutableList.of()).setClassPath((ImmutableList<String>)ImmutableList.of()).setBootClassPath((ImmutableList<String>)ImmutableList.of()).setProcessorPath((ImmutableList<String>)ImmutableList.of()).setProcessors((ImmutableList<String>)ImmutableList.of()).setBuiltinProcessors((ImmutableList<String>)ImmutableList.of()).setSourceJars((ImmutableList<String>)ImmutableList.of()).setDirectJars((ImmutableList<String>)ImmutableList.of()).setDepsArtifacts((ImmutableList<String>)ImmutableList.of()).addAllJavacOpts((Iterable<String>)ImmutableList.of()).setLanguageVersion(LanguageVersion.createDefault()).setReducedClasspathMode(ReducedClasspathMode.NONE).setHelp(false).setFullClasspathLength(0).setReducedClasspathLength(0);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setOutput(String var1);

        public abstract Builder setClassPath(ImmutableList<String> var1);

        public abstract Builder setBootClassPath(ImmutableList<String> var1);

        public abstract Builder setLanguageVersion(LanguageVersion var1);

        public abstract Builder setSystem(String var1);

        public abstract Builder setSources(ImmutableList<String> var1);

        public abstract Builder setProcessorPath(ImmutableList<String> var1);

        public abstract Builder setProcessors(ImmutableList<String> var1);

        public abstract Builder setBuiltinProcessors(ImmutableList<String> var1);

        public abstract Builder setSourceJars(ImmutableList<String> var1);

        public abstract Builder setOutputDeps(String var1);

        public abstract Builder setHeaderCompilationOutput(String var1);

        public abstract Builder setOutputManifest(String var1);

        public abstract Builder setTargetLabel(String var1);

        public abstract Builder setInjectingRuleKind(String var1);

        public abstract Builder setDepsArtifacts(ImmutableList<String> var1);

        public abstract Builder setHelp(boolean var1);

        abstract ImmutableList.Builder<String> javacOptsBuilder();

        @CanIgnoreReturnValue
        public Builder addAllJavacOpts(Iterable<String> javacOpts) {
            this.javacOptsBuilder().addAll(javacOpts);
            return this;
        }

        public abstract Builder setReducedClasspathMode(ReducedClasspathMode var1);

        public abstract Builder setDirectJars(ImmutableList<String> var1);

        public abstract Builder setProfile(String var1);

        public abstract Builder setGensrcOutput(String var1);

        public abstract Builder setResourceOutput(String var1);

        public abstract Builder setFullClasspathLength(int var1);

        public abstract Builder setReducedClasspathLength(int var1);

        public abstract TurbineOptions build();
    }

    public static enum ReducedClasspathMode {
        BAZEL_REDUCED,
        BAZEL_FALLBACK,
        JAVABUILDER_REDUCED,
        NONE;

    }
}

