/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.env;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.Symbol;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class SimpleEnv<K extends Symbol, V>
implements Env<K, V> {
    private final ImmutableMap<K, V> map;

    public SimpleEnv(ImmutableMap<K, V> map) {
        this.map = map;
    }

    public static <K extends Symbol, V> Builder<K, V> builder() {
        return new Builder();
    }

    public ImmutableMap<K, V> asMap() {
        return this.map;
    }

    @Override
    public @Nullable V get(K sym) {
        return (V)this.map.get(sym);
    }

    public static class Builder<K extends Symbol, V> {
        private final Map<K, V> map = new LinkedHashMap();

        @CanIgnoreReturnValue
        public @Nullable V put(K sym, V v) {
            return this.map.put(sym, v);
        }

        public SimpleEnv<K, V> build() {
            return new SimpleEnv(ImmutableMap.copyOf(this.map));
        }
    }
}

