/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.file.visitor;

import java.util.List;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class ResourceFileNameFilter
implements ResourceFileVisitor {
    private final StringMatcher fileNameFilter;
    private final ResourceFileVisitor acceptedVisitor;
    private final ResourceFileVisitor rejectedVisitor;

    public ResourceFileNameFilter(String fileNameRegularExpression, ResourceFileVisitor acceptedVisitor) {
        this(new ListParser(new FileNameParser()).parse(fileNameRegularExpression), acceptedVisitor);
    }

    public ResourceFileNameFilter(StringMatcher fileNameFilter, ResourceFileVisitor acceptedVisitor) {
        this(fileNameFilter, acceptedVisitor, null);
    }

    public ResourceFileNameFilter(List regularExpressions, ResourceFileVisitor acceptedVisitor) {
        this(regularExpressions, acceptedVisitor, null);
    }

    public ResourceFileNameFilter(String fileNameRegularExpression, ResourceFileVisitor acceptedVisitor, ResourceFileVisitor rejectedVisitor) {
        this(new ListParser(new FileNameParser()).parse(fileNameRegularExpression), acceptedVisitor, rejectedVisitor);
    }

    public ResourceFileNameFilter(List regularExpressions, ResourceFileVisitor acceptedVisitor, ResourceFileVisitor rejectedVisitor) {
        this(new ListParser(new FileNameParser()).parse(regularExpressions), acceptedVisitor, rejectedVisitor);
    }

    public ResourceFileNameFilter(StringMatcher fileNameFilter, ResourceFileVisitor acceptedVisitor, ResourceFileVisitor rejectedVisitor) {
        this.fileNameFilter = fileNameFilter;
        this.acceptedVisitor = acceptedVisitor;
        this.rejectedVisitor = rejectedVisitor;
    }

    @Override
    public void visitAnyResourceFile(ResourceFile resourceFile) {
        ResourceFileVisitor delegate = this.getDelegate(resourceFile);
        if (delegate != null) {
            resourceFile.accept(delegate);
        }
    }

    private ResourceFileVisitor getDelegate(ResourceFile resourceFile) {
        return this.fileNameFilter.matches(resourceFile.fileName) ? this.acceptedVisitor : this.rejectedVisitor;
    }
}

