/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import proguard.analysis.cpa.bam.BamLocationDependent;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.BamLocationDependentJvmMemoryLocation;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.MethodSignature;

public class JvmMemoryLocationAbstractState<AbstractStateT extends AbstractState & ProgramLocationDependent<JvmCfaNode, JvmCfaEdge, MethodSignature>>
implements LatticeAbstractState<JvmMemoryLocationAbstractState<AbstractStateT>>,
ProgramLocationDependent<JvmCfaNode, JvmCfaEdge, MethodSignature>,
BamLocationDependent<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> {
    public static final JvmMemoryLocationAbstractState top = new JvmMemoryLocationAbstractState();
    private final BamLocationDependentJvmMemoryLocation<AbstractStateT> locationDependentMemoryLocation;
    private final Set<BamLocationDependentJvmMemoryLocation<AbstractStateT>> sourceLocations;
    private final LinkedList<StackEntry> callStack;

    private JvmMemoryLocationAbstractState() {
        this((BamLocationDependentJvmMemoryLocation)null, null, null);
    }

    public JvmMemoryLocationAbstractState(BamLocationDependentJvmMemoryLocation<AbstractStateT> locationDependentMemoryLocation) {
        this(locationDependentMemoryLocation, new HashSet<BamLocationDependentJvmMemoryLocation<AbstractStateT>>(), new LinkedList<StackEntry>());
    }

    public JvmMemoryLocationAbstractState(JvmMemoryLocation memoryLocation, JvmCfaNode programLocation, ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> sourceReachedSet) {
        this(memoryLocation, programLocation, sourceReachedSet, new HashSet<BamLocationDependentJvmMemoryLocation<AbstractStateT>>());
    }

    public JvmMemoryLocationAbstractState(JvmMemoryLocation memoryLocation, JvmCfaNode programLocation, ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> sourceReachedSet, Set<BamLocationDependentJvmMemoryLocation<AbstractStateT>> sourceLocations) {
        this(memoryLocation, programLocation, sourceReachedSet, sourceLocations, new LinkedList<StackEntry>());
    }

    public JvmMemoryLocationAbstractState(JvmMemoryLocation memoryLocation, JvmCfaNode programLocation, ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> sourceReachedSet, LinkedList<StackEntry> callStack) {
        this(memoryLocation, programLocation, sourceReachedSet, new HashSet<BamLocationDependentJvmMemoryLocation<AbstractStateT>>(), callStack);
    }

    public JvmMemoryLocationAbstractState(JvmMemoryLocation memoryLocation, JvmCfaNode programLocation, ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> sourceReachedSet, Set<BamLocationDependentJvmMemoryLocation<AbstractStateT>> sourceLocations, LinkedList<StackEntry> callStack) {
        this(new BamLocationDependentJvmMemoryLocation<AbstractStateT>(memoryLocation, programLocation, sourceReachedSet), sourceLocations, callStack);
    }

    private JvmMemoryLocationAbstractState(BamLocationDependentJvmMemoryLocation<AbstractStateT> locationDependentMemoryLocation, Set<BamLocationDependentJvmMemoryLocation<AbstractStateT>> sourceLocations, LinkedList<StackEntry> callStack) {
        this.locationDependentMemoryLocation = locationDependentMemoryLocation;
        this.sourceLocations = sourceLocations;
        this.callStack = callStack;
    }

    public BamLocationDependentJvmMemoryLocation<AbstractStateT> getLocationDependentMemoryLocation() {
        return this.locationDependentMemoryLocation;
    }

    public StackEntry peekCallStack() {
        return this.callStack.peek();
    }

    public boolean callStackContains(MethodSignature signature) {
        return this.callStack.stream().anyMatch(e -> signature.equals(e.signature));
    }

    public LinkedList<StackEntry> copyStack() {
        return new LinkedList<StackEntry>(this.callStack);
    }

    @Override
    public JvmMemoryLocationAbstractState join(JvmMemoryLocationAbstractState abstractState) {
        if (!this.locationDependentMemoryLocation.equals(abstractState.locationDependentMemoryLocation)) {
            return top;
        }
        JvmMemoryLocationAbstractState result = this.copy();
        result.sourceLocations.addAll(abstractState.sourceLocations);
        return this.equals(result) ? this : result;
    }

    @Override
    public boolean isLessOrEqual(JvmMemoryLocationAbstractState<AbstractStateT> abstractState) {
        return abstractState == top || this.locationDependentMemoryLocation.equals(abstractState.locationDependentMemoryLocation) && this.callStack.equals(abstractState.callStack) && abstractState.sourceLocations.containsAll(this.sourceLocations);
    }

    @Override
    public JvmCfaNode getProgramLocation() {
        return this.locationDependentMemoryLocation.getProgramLocation();
    }

    @Override
    public void setProgramLocation(JvmCfaNode programLocation) {
        this.locationDependentMemoryLocation.setProgramLocation(programLocation);
    }

    @Override
    public ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> getSourceReachedSet() {
        return this.locationDependentMemoryLocation.getSourceReachedSet();
    }

    @Override
    public void setSourceReachedSet(ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, AbstractStateT, MethodSignature> sourceReachedSet) {
        this.locationDependentMemoryLocation.setSourceReachedSet(sourceReachedSet);
    }

    public void addSourceLocation(BamLocationDependentJvmMemoryLocation<AbstractStateT> sourceLocation) {
        this.sourceLocations.add(sourceLocation);
    }

    public Set<BamLocationDependentJvmMemoryLocation<AbstractStateT>> getSourceLocations() {
        return this.sourceLocations;
    }

    @Override
    public JvmMemoryLocationAbstractState copy() {
        return new JvmMemoryLocationAbstractState<AbstractStateT>(this.locationDependentMemoryLocation.copy(), new HashSet<BamLocationDependentJvmMemoryLocation<AbstractStateT>>(this.sourceLocations), this.callStack);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JvmMemoryLocationAbstractState)) {
            return false;
        }
        JvmMemoryLocationAbstractState other = (JvmMemoryLocationAbstractState)obj;
        return Objects.equals(this.locationDependentMemoryLocation, other.locationDependentMemoryLocation) && Objects.equals(this.callStack, other.callStack) && Objects.equals(this.sourceLocations, other.sourceLocations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.locationDependentMemoryLocation);
    }

    public static class StackEntry {
        public final MethodSignature signature;
        public final ProgramLocationDependentReachedSet reachedSet;
        public final AbstractState callerState;

        public StackEntry(MethodSignature signature, ProgramLocationDependentReachedSet reachedSet, AbstractState callerState) {
            this.signature = signature;
            this.reachedSet = reachedSet;
            this.callerState = callerState;
        }

        public int hashCode() {
            return Objects.hash(this.signature, this.reachedSet, this.callerState);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StackEntry)) {
                return false;
            }
            StackEntry other = (StackEntry)obj;
            return this.reachedSet == other.reachedSet && Objects.equals(this.signature, other.signature) && Objects.equals(this.callerState, other.callerState);
        }
    }
}

