/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.context;

import com.google.common.flogger.context.ContextDataProvider;
import com.google.common.flogger.context.LogLevelMap;
import com.google.common.flogger.context.Tags;
import java.io.Closeable;
import java.util.concurrent.Callable;

public abstract class ScopedLoggingContext {
    public static ScopedLoggingContext getInstance() {
        return ContextDataProvider.getInstance().getContextApiSingleton();
    }

    protected ScopedLoggingContext() {
    }

    public abstract Closeable withNewScope();

    public abstract boolean applyLogLevelMap(LogLevelMap var1);

    public abstract boolean addTags(Tags var1);

    public final Runnable wrap(final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                Closeable scope = ScopedLoggingContext.this.withNewScope();
                boolean hasError = true;
                try {
                    r.run();
                    hasError = false;
                }
                finally {
                    ScopedLoggingContext.closeAndMaybePropagateError(scope, hasError);
                }
            }
        };
    }

    public final <R> Callable<R> wrap(final Callable<R> c) {
        return new Callable<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R call() throws Exception {
                Closeable scope = ScopedLoggingContext.this.withNewScope();
                boolean hasError = true;
                try {
                    Object result = c.call();
                    hasError = false;
                    Object v = result;
                    return v;
                }
                finally {
                    ScopedLoggingContext.closeAndMaybePropagateError(scope, hasError);
                }
            }
        };
    }

    private static void closeAndMaybePropagateError(Closeable scope, boolean callerHasError) {
        block2: {
            try {
                scope.close();
            }
            catch (Throwable e) {
                if (callerHasError) break block2;
                throw e instanceof InvalidLoggingScopeStateException ? (InvalidLoggingScopeStateException)e : new InvalidLoggingScopeStateException("invalid logging context state", e);
            }
        }
    }

    public final void run(Runnable r) {
        this.wrap(r).run();
    }

    public final <R> R call(Callable<R> c) throws Exception {
        return this.wrap(c).call();
    }

    public static final class InvalidLoggingScopeStateException
    extends IllegalStateException {
        public InvalidLoggingScopeStateException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidLoggingScopeStateException(String message) {
            super(message);
        }
    }
}

