/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.ChicoryInterruptedException;
import com.dylibso.chicory.runtime.ConstantEvaluators;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.WasmRuntimeException;
import com.dylibso.chicory.runtime.alloc.DefaultMemAllocStrategy;
import com.dylibso.chicory.runtime.alloc.MemAllocStrategy;
import com.dylibso.chicory.wasm.ChicoryException;
import com.dylibso.chicory.wasm.UninstantiableException;
import com.dylibso.chicory.wasm.types.ActiveDataSegment;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import com.dylibso.chicory.wasm.types.PassiveDataSegment;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public final class ByteArrayMemory
implements Memory {
    private static final VarHandle SHORT_ARR_HANDLE = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_ARR_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle FLOAT_ARR_HANDLE = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle LONG_ARR_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle DOUBLE_ARR_HANDLE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.LITTLE_ENDIAN);
    private final MemoryLimits limits;
    private DataSegment[] dataSegments;
    private byte[] buffer;
    private int nPages;
    private final MemAllocStrategy allocStrategy;
    private final Map<Integer, AtomicInteger> monitors;
    private final Map<Integer, AtomicInteger> notifyInProgress;

    public ByteArrayMemory(MemoryLimits limits) {
        this(limits, new DefaultMemAllocStrategy(Memory.bytes(limits.maximumPages())));
    }

    public ByteArrayMemory(MemoryLimits limits, MemAllocStrategy allocStrategy) {
        this.allocStrategy = allocStrategy;
        this.limits = limits;
        this.buffer = new byte[allocStrategy.initial(65536 * limits.initialPages())];
        this.nPages = limits.initialPages();
        if (limits.shared()) {
            this.monitors = new ConcurrentHashMap<Integer, AtomicInteger>();
            this.notifyInProgress = new ConcurrentHashMap<Integer, AtomicInteger>();
        } else {
            this.monitors = null;
            this.notifyInProgress = null;
        }
    }

    @Override
    public Object lock(int address) {
        if (!this.shared()) {
            return new Object();
        }
        return this.monitors.computeIfAbsent(address, k -> new AtomicInteger(0));
    }

    private AtomicInteger nextMonitor(int address) {
        return this.monitors.compute(address, (k, v) -> {
            if (v == null) {
                return new AtomicInteger(1);
            }
            v.incrementAndGet();
            return v;
        });
    }

    private int waitOnMonitor(int address, long timeout, AtomicInteger monitor) {
        long endTime = System.nanoTime() + timeout;
        try {
            while (!this.notifyInProgress.containsKey(address) && System.nanoTime() < endTime) {
                long waitTime = endTime - System.nanoTime();
                long millis = Math.max(waitTime / 1000000L, 0L);
                int nanos = Math.max((int)(waitTime % 1000000L), 0);
                monitor.wait(millis, nanos);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new ChicoryInterruptedException("Thread interrupted");
        }
        if (System.nanoTime() >= endTime) {
            return 2;
        }
        return 0;
    }

    private void endWaitOn(int address) {
        AtomicInteger monitor;
        AtomicInteger notifyCount = this.notifyInProgress.get(address);
        if (notifyCount != null && notifyCount.decrementAndGet() == 0) {
            this.notifyInProgress.remove(address);
        }
        if ((monitor = this.monitors.get(address)) != null && monitor.decrementAndGet() == 0) {
            this.monitors.remove(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int waitOn(int address, int expected, long timeout) {
        AtomicInteger monitor;
        if (!this.shared()) {
            throw new ChicoryException("Attempt to wait on a non-shared memory, not supported.");
        }
        AtomicInteger atomicInteger = monitor = this.nextMonitor(address);
        synchronized (atomicInteger) {
            try {
                if (this.readInt(address) == expected) {
                    int n = this.waitOnMonitor(address, timeout < 0L ? Long.MAX_VALUE : timeout, monitor);
                    return n;
                }
                int n = 1;
                return n;
            }
            finally {
                this.endWaitOn(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int waitOn(int address, long expected, long timeout) {
        AtomicInteger monitor;
        if (!this.shared()) {
            throw new ChicoryException("Attempt to wait on a non-shared memory, not supported.");
        }
        AtomicInteger atomicInteger = monitor = this.nextMonitor(address);
        synchronized (atomicInteger) {
            try {
                if (this.readLong(address) == expected) {
                    int n = this.waitOnMonitor(address, timeout < 0L ? Long.MAX_VALUE : timeout, monitor);
                    return n;
                }
                int n = 1;
                return n;
            }
            finally {
                this.endWaitOn(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int notify(int address, int maxThreads) {
        if (!this.shared()) {
            return 0;
        }
        AtomicInteger monitor = this.monitors.get(address);
        if (monitor == null) {
            return 0;
        }
        AtomicInteger atomicInteger = monitor;
        synchronized (atomicInteger) {
            if (maxThreads < 0 || monitor.get() < maxThreads) {
                this.notifyInProgress.put(address, new AtomicInteger(monitor.get()));
                monitor.notifyAll();
            } else {
                this.notifyInProgress.put(address, new AtomicInteger(monitor.get() - maxThreads));
                for (int count = maxThreads; monitor.get() > 0 && count > 0; --count) {
                    monitor.notify();
                }
            }
        }
        if (monitor.get() <= 0) {
            this.monitors.remove(address);
        }
        return monitor.get();
    }

    private byte[] allocateByteBuffer(int capacity) {
        if (capacity > this.buffer.length) {
            int nextCapacity = this.allocStrategy.next(this.buffer.length, capacity);
            return new byte[nextCapacity];
        }
        return this.buffer;
    }

    @Override
    public int pages() {
        return this.nPages;
    }

    @Override
    public int grow(int size) {
        int prevPages = this.nPages;
        int numPages = prevPages + size;
        if (numPages > this.maximumPages() || numPages < prevPages) {
            return -1;
        }
        byte[] newBuffer = this.allocateByteBuffer(65536 * numPages);
        if (newBuffer != this.buffer) {
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.nPages = numPages;
        return prevPages;
    }

    @Override
    public int initialPages() {
        return this.limits.initialPages();
    }

    @Override
    public int maximumPages() {
        return Math.min(this.limits.maximumPages(), Short.MAX_VALUE);
    }

    @Override
    public boolean shared() {
        return this.limits.shared();
    }

    @Override
    public void initialize(Instance instance, DataSegment[] dataSegments) {
        this.dataSegments = dataSegments;
        if (dataSegments == null) {
            return;
        }
        for (DataSegment s : dataSegments) {
            if (s instanceof ActiveDataSegment) {
                ActiveDataSegment segment = (ActiveDataSegment)s;
                List offsetExpr = segment.offsetInstructions();
                byte[] data = segment.data();
                int offset = (int)ConstantEvaluators.computeConstantValue(instance, offsetExpr)[0];
                ByteArrayMemory.checkBounds(offset, data.length, this.sizeInBytes(), msg -> new UninstantiableException(msg));
                System.arraycopy(data, 0, this.buffer, offset, data.length);
                continue;
            }
            if (s instanceof PassiveDataSegment) continue;
            throw new ChicoryException("Data segment should be active or passive: " + String.valueOf(s));
        }
    }

    private static void checkBounds(int addr, int size, int limit, Function<String, ChicoryException> exceptionFactory) {
        if (addr < 0 || size < 0 || addr > limit || size > 0 && addr + size > limit) {
            String errorMsg = "out of bounds memory access: attempted to access address: " + addr + " but limit is: " + limit + " and size: " + size;
            throw exceptionFactory.apply(errorMsg);
        }
    }

    private static RuntimeException outOfBoundsException(RuntimeException e, int addr, int size, int limit) {
        if (e instanceof IndexOutOfBoundsException || e instanceof BufferOverflowException || e instanceof BufferUnderflowException || e instanceof IllegalArgumentException || e instanceof NegativeArraySizeException) {
            String errorMsg = "out of bounds memory access: attempted to access address: " + addr + " but limit is: " + limit + " and size: " + size;
            return new WasmRuntimeException(errorMsg);
        }
        return e;
    }

    @Override
    public void initPassiveSegment(int segmentId, int dest, int offset, int size) {
        DataSegment segment = this.dataSegments[segmentId];
        this.write(dest, segment.data(), offset, size);
    }

    private int sizeInBytes() {
        return 65536 * this.nPages;
    }

    @Override
    public void write(int addr, byte[] data, int offset, int size) {
        try {
            System.arraycopy(data, offset, this.buffer, addr, size);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, size, this.sizeInBytes());
        }
    }

    @Override
    public byte read(int addr) {
        try {
            return this.buffer[addr];
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 1, this.sizeInBytes());
        }
    }

    @Override
    public byte[] readBytes(int addr, int len) {
        try {
            byte[] bytes = new byte[len];
            System.arraycopy(this.buffer, addr, bytes, 0, len);
            return bytes;
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, len, this.sizeInBytes());
        }
    }

    @Override
    public void writeI32(int addr, int data) {
        try {
            INT_ARR_HANDLE.set(this.buffer, addr, data);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 4, this.sizeInBytes());
        }
    }

    @Override
    public int readInt(int addr) {
        try {
            return INT_ARR_HANDLE.get(this.buffer, addr);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 4, this.sizeInBytes());
        }
    }

    @Override
    public void writeLong(int addr, long data) {
        try {
            LONG_ARR_HANDLE.set(this.buffer, addr, data);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 8, this.sizeInBytes());
        }
    }

    @Override
    public long readLong(int addr) {
        try {
            return LONG_ARR_HANDLE.get(this.buffer, addr);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 8, this.sizeInBytes());
        }
    }

    @Override
    public void writeShort(int addr, short data) {
        try {
            SHORT_ARR_HANDLE.set(this.buffer, addr, data);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 2, this.sizeInBytes());
        }
    }

    @Override
    public short readShort(int addr) {
        try {
            return SHORT_ARR_HANDLE.get(this.buffer, addr);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 2, this.sizeInBytes());
        }
    }

    @Override
    public long readU16(int addr) {
        try {
            return SHORT_ARR_HANDLE.get(this.buffer, addr) & 0xFFFF;
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 2, this.sizeInBytes());
        }
    }

    @Override
    public void writeByte(int addr, byte data) {
        try {
            this.buffer[addr] = data;
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 1, this.sizeInBytes());
        }
    }

    @Override
    public void writeF32(int addr, float data) {
        try {
            FLOAT_ARR_HANDLE.set(this.buffer, addr, data);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 4, this.sizeInBytes());
        }
    }

    @Override
    public long readF32(int addr) {
        try {
            return INT_ARR_HANDLE.get(this.buffer, addr);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 4, this.sizeInBytes());
        }
    }

    @Override
    public float readFloat(int addr) {
        try {
            return FLOAT_ARR_HANDLE.get(this.buffer, addr);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 4, this.sizeInBytes());
        }
    }

    @Override
    public void writeF64(int addr, double data) {
        try {
            DOUBLE_ARR_HANDLE.set(this.buffer, addr, data);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 8, this.sizeInBytes());
        }
    }

    @Override
    public double readDouble(int addr) {
        try {
            return DOUBLE_ARR_HANDLE.get(this.buffer, addr);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 8, this.sizeInBytes());
        }
    }

    @Override
    public long readF64(int addr) {
        try {
            return LONG_ARR_HANDLE.get(this.buffer, addr);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, addr, 8, this.sizeInBytes());
        }
    }

    @Override
    public void zero() {
        this.fill((byte)0, 0, this.sizeInBytes());
    }

    @Override
    public void fill(byte value, int fromIndex, int toIndex) {
        try {
            Arrays.fill(this.buffer, fromIndex, toIndex, value);
        }
        catch (RuntimeException e) {
            throw ByteArrayMemory.outOfBoundsException(e, fromIndex, toIndex - fromIndex, this.sizeInBytes());
        }
    }

    @Override
    public void drop(int segment) {
        this.dataSegments[segment] = PassiveDataSegment.EMPTY;
    }
}

