/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.refaster.AutoValue_ULambda;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UPlaceholderExpression;
import com.google.errorprone.refaster.UTree;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Optional;

@AutoValue
abstract class ULambda
extends UExpression
implements LambdaExpressionTree {
    ULambda() {
    }

    public static ULambda create(JCTree.JCLambda.ParameterKind parameterKind, Iterable<UVariableDecl> parameters, UTree<?> body) {
        return new AutoValue_ULambda(parameterKind, (ImmutableList<UVariableDecl>)ImmutableList.copyOf(parameters), body);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.LAMBDA_EXPRESSION;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitLambdaExpression(this, data);
    }

    @Override
    public Choice<Unifier> visitLambdaExpression(LambdaExpressionTree node, Unifier unifier) {
        return Unifier.unifyList(unifier, this.getParameters(), node.getParameters()).flatMap(Unifier.unifications(this.getBody(), node.getBody()));
    }

    @Override
    public JCTree.JCLambda inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().Lambda(this.inlineParams(inliner), this.inlineBody(inliner));
    }

    public List<JCTree.JCVariableDecl> inlineParams(Inliner inliner) throws CouldNotResolveImportException {
        if (this.parameterKind() == JCTree.JCLambda.ParameterKind.EXPLICIT) {
            return List.convert(JCTree.JCVariableDecl.class, inliner.inlineList(this.getParameters()));
        }
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        for (UVariableDecl param : this.getParameters()) {
            params.add(param.inlineImplicitType(inliner));
        }
        return params.toList();
    }

    JCTree inlineBody(Inliner inliner) throws CouldNotResolveImportException {
        UPlaceholderExpression body;
        Optional<List<JCTree.JCStatement>> blockBinding;
        Tree tree = this.getBody();
        if (tree instanceof UPlaceholderExpression && (blockBinding = inliner.getOptionalBinding((body = (UPlaceholderExpression)tree).placeholder().blockKey())).isPresent()) {
            List<JCTree.JCStatement> blockInlined = UPlaceholderExpression.copier(body.arguments(), inliner).copy(blockBinding.get(), inliner);
            if (blockInlined.size() == 1) {
                JCTree.JCStatement jCStatement = blockInlined.get(0);
                if (jCStatement instanceof JCTree.JCReturn) {
                    JCTree.JCReturn jCReturn = (JCTree.JCReturn)jCStatement;
                    return jCReturn.getExpression();
                }
                jCStatement = blockInlined.get(0);
                if (jCStatement instanceof JCTree.JCExpressionStatement) {
                    JCTree.JCExpressionStatement jCExpressionStatement = (JCTree.JCExpressionStatement)jCStatement;
                    return jCExpressionStatement.getExpression();
                }
            }
            return inliner.maker().Block(0L, blockInlined);
        }
        return (JCTree)this.getBody().inline(inliner);
    }

    abstract JCTree.JCLambda.ParameterKind parameterKind();

    public abstract ImmutableList<UVariableDecl> getParameters();

    @Override
    public abstract UTree<?> getBody();

    @Override
    public LambdaExpressionTree.BodyKind getBodyKind() {
        return this.getBody() instanceof BlockTree ? LambdaExpressionTree.BodyKind.STATEMENT : LambdaExpressionTree.BodyKind.EXPRESSION;
    }
}

