/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.NearbyCallers;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Prefer duration.toSeconds() over duration.getSeconds()", explanation="duration.getSeconds() is a decomposition API which should always be used alongside duration.getNano(). duration.toSeconds() is a conversion API, and the preferred way to convert to seconds.", severity=BugPattern.SeverityLevel.WARNING)
public final class JavaDurationGetSecondsToToSeconds
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GET_SECONDS = MethodMatchers.instanceMethod().onExactClass("java.time.Duration").named("getSeconds");
    private static final Matcher<ExpressionTree> GET_NANO = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("java.time.Duration").named("getNano"), Matchers.not((Matcher)Matchers.packageStartsWith((String)"java."))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (GET_SECONDS.matches((Tree)tree, state) && !NearbyCallers.containsCallToSameReceiverNearby(tree, GET_NANO, state, false)) {
            return this.describeMatch(tree, (Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"toSeconds", (VisitorState)state));
        }
        return Description.NO_MATCH;
    }
}

