/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.threadsafety.AutoOneOf_ConstantExpressions_ConstantExpression;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_ConstantExpressions_ConstantEquals;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_ConstantExpressions_PureMethodInvocation;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_ConstantExpressions_Truthiness;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

public final class ConstantExpressions {
    private final Matcher<ExpressionTree> pureMethods;
    private final Supplier<ThreadSafety> threadSafety;
    private static final Pattern NOT_NOW = Pattern.compile("^?!(now)");
    private final Matcher<ExpressionTree> basePureMethods = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny(new String[]{"com.google.common.base.Optional", "com.google.common.base.Pair", "com.google.common.base.Splitter", "com.google.common.collect.ImmutableBiMap", "com.google.common.collect.ImmutableCollection", "com.google.common.collect.ImmutableList", "com.google.common.collect.ImmutableListMultimap", "com.google.common.collect.ImmutableMap", "com.google.common.collect.ImmutableMultimap", "com.google.common.collect.ImmutableMultiset", "com.google.common.collect.ImmutableRangeMap", "com.google.common.collect.ImmutableRangeSet", "com.google.common.collect.ImmutableSet", "com.google.common.collect.ImmutableSetMultimap", "com.google.common.collect.ImmutableSortedMap", "com.google.common.collect.ImmutableSortedMultiset", "com.google.common.collect.ImmutableSortedSet", "com.google.common.collect.ImmutableTable", "com.google.common.collect.Range"}), MethodMatchers.staticMethod().onClass("com.google.protobuf.GeneratedMessage"), MethodMatchers.staticMethod().onClass("java.time.Duration").namedAnyOf(new String[]{"ofNanos", "ofMillis", "ofSeconds", "ofMinutes", "ofHours", "ofDays"}).withParameters("long", new String[0]), MethodMatchers.staticMethod().onClass("java.time.Instant").namedAnyOf(new String[]{"ofEpochMilli", "ofEpochSecond"}).withParameters("long", new String[0]), MethodMatchers.staticMethod().onClass("com.google.protobuf.util.Timestamps").namedAnyOf(new String[]{"fromNanos", "fromMicros", "fromMillis", "fromSeconds"}), MethodMatchers.staticMethod().onClass("com.google.protobuf.util.Durations").namedAnyOf(new String[]{"fromNanos", "fromMicros", "fromMillis", "fromSeconds", "fromMinutes", "fromHours", "fromDays"}), MethodMatchers.staticMethod().onClass("org.joda.time.Duration").namedAnyOf(new String[]{"millis", "standardSeconds", "standardMinutes", "standardHours", "standardDays"}).withParameters("long", new String[0]), MethodMatchers.constructor().forClass("org.joda.time.Instant").withParameters("long", new String[0]), MethodMatchers.constructor().forClass("org.joda.time.DateTime").withParameters("long", new String[0]), MethodMatchers.staticMethod().onClass("java.time.LocalDate").withNameMatching(NOT_NOW), MethodMatchers.staticMethod().onClass("java.time.LocalDateTime").withNameMatching(NOT_NOW), MethodMatchers.staticMethod().onClass("java.time.LocalTime").withNameMatching(NOT_NOW), MethodMatchers.staticMethod().onClass("java.time.MonthDay"), MethodMatchers.staticMethod().onClass("java.time.OffsetDateTime").withNameMatching(NOT_NOW), MethodMatchers.staticMethod().onClass("java.time.OffsetTime").withNameMatching(NOT_NOW), MethodMatchers.staticMethod().onClassAny(new String[]{"java.time.Period", "java.time.Year", "java.time.YearMonth", "java.time.ZoneId", "java.time.ZoneOffset"}), MethodMatchers.instanceMethod().onDescendantOf("java.lang.String"), MethodMatchers.staticMethod().onClass("java.time.ZonedDateTime").withNameMatching(NOT_NOW), MethodMatchers.staticMethod().onClassAny(new String[]{"java.util.Optional", "java.util.OptionalDouble", "java.util.OptionalInt", "java.util.OptionalLong"}), MethodMatchers.staticMethod().onClass("java.util.regex.Pattern"), MethodMatchers.staticMethod().onClassAny(new String[]{"org.joda.time.DateTime", "org.joda.time.DateTimeZone", "org.joda.time.Days", "org.joda.time.Duration", "org.joda.time.Instant", "org.joda.time.Interval", "org.joda.time.LocalDate", "org.joda.time.LocalDateTime", "org.joda.time.Period", "org.joda.time.format.DateTimeFormatter"}), Matchers.anyMethod().onClass("java.lang.String"), Matchers.hasAnnotation((String)"org.checkerframework.dataflow.qual.Pure"), (Matcher & Serializable)(tree, state) -> {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return ASTHelpers.hasAnnotation((Symbol)symbol.owner, (String)"com.google.auto.value.AutoValue", (VisitorState)state) && symbol.getModifiers().contains((Object)Modifier.ABSTRACT);
    }, MethodMatchers.staticMethod().onDescendantOf("com.google.protobuf.MessageLite").named("getDefaultInstance"), Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceEqualsInvocation(), (Matcher & Serializable)(t, s) -> {
        if (!(t instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)t;
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)t);
        if (receiver == null) {
            return false;
        }
        return this.typeIsImmutable(ASTHelpers.getType((Tree)receiver), s) && this.typeIsImmutable(ASTHelpers.getType((Tree)methodInvocationTree.getArguments().get(0)), s);
    }}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticEqualsInvocation(), (Matcher & Serializable)(t, s) -> {
        if (!(t instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)t;
        List<? extends ExpressionTree> args = methodInvocationTree.getArguments();
        return this.typeIsImmutable(ASTHelpers.getType((Tree)args.get(0)), s) && this.typeIsImmutable(ASTHelpers.getType((Tree)args.get(1)), s);
    }})});

    @Inject
    ConstantExpressions(WellKnownMutability wellKnownMutability, ErrorProneFlags flags) {
        boolean considerAllMethodsPure = flags.getBoolean("ConstantExpressions:ConsiderAllMethodsPure").orElse(false);
        this.pureMethods = considerAllMethodsPure ? Matchers.anyMethod() : Matchers.anyOf((Matcher[])new Matcher[]{this.basePureMethods, MethodMatchers.instanceMethod().onDescendantOfAny((Iterable)wellKnownMutability.getKnownImmutableClasses().keySet())});
        this.threadSafety = VisitorState.memoize((Supplier & Serializable)s -> ThreadSafety.builder().setPurpose(ThreadSafety.Purpose.FOR_IMMUTABLE_CHECKER).knownTypes(wellKnownMutability).acceptedAnnotations((Iterable<String>)ImmutableSet.of((Object)Immutable.class.getName())).markerAnnotations((Iterable<String>)ImmutableSet.of()).build(s));
    }

    public static ConstantExpressions fromFlags(ErrorProneFlags flags) {
        return new ConstantExpressions(WellKnownMutability.fromFlags(flags), flags);
    }

    public Truthiness truthiness(ExpressionTree tree, final boolean not, final VisitorState state) {
        final ImmutableSet.Builder requiredTrue = ImmutableSet.builder();
        final ImmutableSet.Builder requiredFalse = ImmutableSet.builder();
        final AtomicBoolean failed = new AtomicBoolean();
        new SimpleTreeVisitor<Void, Void>(this){
            boolean negated;
            final /* synthetic */ ConstantExpressions this$0;
            {
                this.this$0 = this$0;
                this.negated = not;
            }

            @Override
            public Void visitParenthesized(ParenthesizedTree tree, Void unused) {
                return (Void)this.visit(tree.getExpression(), null);
            }

            @Override
            public Void visitUnary(UnaryTree tree, Void unused) {
                if (tree.getKind().equals((Object)Tree.Kind.LOGICAL_COMPLEMENT)) {
                    this.withNegation(() -> this.visit(tree.getExpression(), null));
                }
                return null;
            }

            @Override
            public Void visitBinary(BinaryTree tree, Void unused) {
                if (tree.getKind().equals((Object)Tree.Kind.EQUAL_TO) || tree.getKind().equals((Object)Tree.Kind.NOT_EQUAL_TO)) {
                    this.this$0.constantExpression(tree, state).ifPresent(e -> {
                        if (tree.getKind().equals((Object)Tree.Kind.NOT_EQUAL_TO)) {
                            this.withNegation(() -> this.add((ConstantExpression)e));
                        } else {
                            this.add((ConstantExpression)e);
                        }
                    });
                } else if (this.negated ? tree.getKind().equals((Object)Tree.Kind.CONDITIONAL_OR) : tree.getKind().equals((Object)Tree.Kind.CONDITIONAL_AND)) {
                    this.visit(tree.getLeftOperand(), null);
                    this.visit(tree.getRightOperand(), null);
                } else {
                    failed.set(true);
                }
                return null;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                this.this$0.constantExpression(tree, state).ifPresent(this::add);
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                this.this$0.constantExpression(tree, state).ifPresent(this::add);
                return null;
            }

            private void withNegation(Runnable runnable) {
                this.negated = !this.negated;
                runnable.run();
                this.negated = !this.negated;
            }

            private void add(ConstantExpression e) {
                if (this.negated) {
                    requiredFalse.add((Object)e);
                } else {
                    requiredTrue.add((Object)e);
                }
            }
        }.visit(tree, null);
        if (failed.get()) {
            return Truthiness.create((Iterable<ConstantExpression>)ImmutableSet.of(), (Iterable<ConstantExpression>)ImmutableSet.of());
        }
        return Truthiness.create((Iterable<ConstantExpression>)requiredTrue.build(), (Iterable<ConstantExpression>)requiredFalse.build());
    }

    public Optional<ConstantExpression> constantExpression(ExpressionTree tree, VisitorState state) {
        Object value;
        if (tree.getKind().equals((Object)Tree.Kind.EQUAL_TO) || tree.getKind().equals((Object)Tree.Kind.NOT_EQUAL_TO)) {
            BinaryTree binaryTree = (BinaryTree)tree;
            Optional<ConstantExpression> lhs = this.constantExpression(binaryTree.getLeftOperand(), state);
            Optional<ConstantExpression> rhs = this.constantExpression(binaryTree.getRightOperand(), state);
            if (lhs.isPresent() && rhs.isPresent()) {
                return Optional.of(ConstantExpression.constantEquals(ConstantEquals.of(lhs.get(), rhs.get())));
            }
        }
        if ((value = ASTHelpers.constValue((Tree)tree)) != null && tree instanceof LiteralTree) {
            return Optional.of(ConstantExpression.literal(value));
        }
        return this.symbolizeImmutableExpression(tree, state).map(ConstantExpression::pureMethod);
    }

    public boolean isSame(ExpressionTree aTree, ExpressionTree bTree, VisitorState state) {
        Optional<ConstantExpression> a = this.constantExpression(aTree, state);
        if (a.isEmpty()) {
            return false;
        }
        Optional<ConstantExpression> b = this.constantExpression(bTree, state);
        return b.isPresent() && a.get().equals(b.get());
    }

    public Optional<PureMethodInvocation> symbolizeImmutableExpression(ExpressionTree tree, VisitorState state) {
        Optional<Object> receiverConstant;
        ExpressionTree receiver = tree instanceof MethodInvocationTree || tree instanceof MemberSelectTree ? ASTHelpers.getReceiver((ExpressionTree)tree) : null;
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (receiver == null || symbol != null && ASTHelpers.isStatic((Symbol)symbol)) {
            receiverConstant = Optional.empty();
        } else {
            receiverConstant = this.constantExpression(receiver, state);
            if (receiverConstant.isEmpty()) {
                return Optional.empty();
            }
        }
        if (ConstantExpressions.isPureIdentifier(tree)) {
            return Optional.of(PureMethodInvocation.of(ASTHelpers.getSymbol((Tree)tree), (Iterable<ConstantExpression>)ImmutableList.of(), receiverConstant));
        }
        if (tree instanceof MethodInvocationTree) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
            if (this.pureMethods.matches((Tree)tree, state)) {
                ImmutableList.Builder arguments = ImmutableList.builder();
                for (ExpressionTree expressionTree : methodInvocationTree.getArguments()) {
                    Optional<ConstantExpression> argumentConstant = this.constantExpression(expressionTree, state);
                    if (argumentConstant.isEmpty()) {
                        return Optional.empty();
                    }
                    arguments.add((Object)argumentConstant.get());
                }
                return Optional.of(PureMethodInvocation.of(ASTHelpers.getSymbol((Tree)tree), (Iterable<ConstantExpression>)arguments.build(), receiverConstant));
            }
        }
        return Optional.empty();
    }

    private static boolean isPureIdentifier(ExpressionTree receiver) {
        if (!(receiver instanceof IdentifierTree) && !(receiver instanceof MemberSelectTree)) {
            return false;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)receiver);
        return symbol.owner.isEnum() || symbol instanceof Symbol.VarSymbol && ASTHelpers.isConsideredFinal((Symbol)symbol) || symbol instanceof Symbol.ClassSymbol || symbol instanceof Symbol.PackageSymbol;
    }

    private boolean typeIsImmutable(Type type, VisitorState state) {
        ThreadSafety threadSafety = (ThreadSafety)this.threadSafety.get(state);
        return !threadSafety.isThreadSafeType(true, threadSafety.threadSafeTypeParametersInScope(type.tsym), type).isPresent();
    }

    @AutoValue
    public static abstract class Truthiness {
        public abstract ImmutableSet<ConstantExpression> requiredTrue();

        public abstract ImmutableSet<ConstantExpression> requiredFalse();

        private static Truthiness create(Iterable<ConstantExpression> requiredTrue, Iterable<ConstantExpression> requiredFalse) {
            return new AutoValue_ConstantExpressions_Truthiness((ImmutableSet<ConstantExpression>)ImmutableSet.copyOf(requiredTrue), (ImmutableSet<ConstantExpression>)ImmutableSet.copyOf(requiredFalse));
        }
    }

    @AutoOneOf(value=ConstantExpressionKind.class)
    public static abstract class ConstantExpression {
        public abstract ConstantExpressionKind kind();

        abstract Object literal();

        private static ConstantExpression literal(Object object) {
            return AutoOneOf_ConstantExpressions_ConstantExpression.literal(object);
        }

        abstract ConstantEquals constantEquals();

        private static ConstantExpression constantEquals(ConstantEquals constantEquals) {
            return AutoOneOf_ConstantExpressions_ConstantExpression.constantEquals(constantEquals);
        }

        public abstract PureMethodInvocation pureMethod();

        private static ConstantExpression pureMethod(PureMethodInvocation pureMethodInvocation) {
            return AutoOneOf_ConstantExpressions_ConstantExpression.pureMethod(pureMethodInvocation);
        }

        public final String toString() {
            return switch (this.kind().ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.literal().toString();
                case 1 -> this.constantEquals().toString();
                case 2 -> this.pureMethod().toString();
            };
        }

        public void accept(ConstantExpressionVisitor visitor) {
            switch (this.kind().ordinal()) {
                case 0: {
                    visitor.visitConstant(this.literal());
                    break;
                }
                case 1: {
                    this.constantEquals().lhs().accept(visitor);
                    this.constantEquals().rhs().accept(visitor);
                    break;
                }
                case 2: {
                    this.pureMethod().accept(visitor);
                }
            }
        }

        public static enum ConstantExpressionKind {
            LITERAL,
            CONSTANT_EQUALS,
            PURE_METHOD;

        }
    }

    @AutoValue
    public static abstract class ConstantEquals {
        abstract ConstantExpression lhs();

        abstract ConstantExpression rhs();

        public final boolean equals(@Nullable Object other) {
            if (!(other instanceof ConstantEquals)) {
                return false;
            }
            ConstantEquals that = (ConstantEquals)other;
            return this.lhs().equals(that.lhs()) && this.rhs().equals(that.rhs()) || this.lhs().equals(that.rhs()) && this.rhs().equals(that.lhs());
        }

        public final String toString() {
            return String.format("%s equals %s", this.lhs(), this.rhs());
        }

        public final int hashCode() {
            return this.lhs().hashCode() + this.rhs().hashCode();
        }

        static ConstantEquals of(ConstantExpression lhs, ConstantExpression rhs) {
            return new AutoValue_ConstantExpressions_ConstantEquals(lhs, rhs);
        }
    }

    @AutoValue
    public static abstract class PureMethodInvocation {
        public abstract Symbol symbol();

        abstract ImmutableList<ConstantExpression> arguments();

        public abstract Optional<ConstantExpression> receiver();

        public final String toString() {
            String receiver = this.receiver().map(r -> String.valueOf(r) + ".").orElse("");
            if (this.symbol() instanceof Symbol.VarSymbol || this.symbol() instanceof Symbol.ClassSymbol) {
                return receiver + String.valueOf(this.symbol().getSimpleName());
            }
            return receiver + (String)(ASTHelpers.isStatic((Symbol)this.symbol()) ? String.valueOf(this.symbol().owner.getSimpleName()) + "." : "") + String.valueOf(this.symbol().getSimpleName()) + this.arguments().stream().map(Object::toString).collect(Collectors.joining(", ", "(", ")"));
        }

        private static PureMethodInvocation of(Symbol symbol, Iterable<ConstantExpression> arguments, Optional<ConstantExpression> receiver) {
            return new AutoValue_ConstantExpressions_PureMethodInvocation(symbol, (ImmutableList<ConstantExpression>)ImmutableList.copyOf(arguments), receiver);
        }

        public void accept(ConstantExpressionVisitor visitor) {
            visitor.visitIdentifier(this.symbol());
            this.arguments().forEach(a -> a.accept(visitor));
            this.receiver().ifPresent(r -> r.accept(visitor));
        }
    }

    public static interface ConstantExpressionVisitor {
        default public void visitConstant(Object constant) {
        }

        default public void visitIdentifier(Symbol identifier) {
        }
    }
}

