/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Apply @NullMarked to this package", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class AddNullMarkedToPackageInfo
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree unit, VisitorState state) {
        if (!AddNullMarkedToPackageInfo.isPackageInfo(unit)) {
            return Description.NO_MATCH;
        }
        boolean nullMarkedAnnotationPresent = unit.getPackageAnnotations().stream().anyMatch(annotation -> ASTHelpers.getAnnotationName((AnnotationTree)annotation).contentEquals("NullMarked"));
        if (nullMarkedAnnotationPresent) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(unit.getPackage(), (Fix)SuggestedFix.builder().prefixWith((Tree)unit.getPackage(), "@NullMarked ").addImport("org.jspecify.annotations.NullMarked").build());
    }

    private static boolean isPackageInfo(CompilationUnitTree tree) {
        String name = ASTHelpers.getFileName((CompilationUnitTree)tree);
        int idx = name.lastIndexOf(47);
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        return name.equals("package-info.java");
    }
}

