/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="This method uses a pair of parameters as a format string and its arguments, but the enclosing method wasn't annotated. Doing so gives compile-time rather than run-time protection against malformed format strings.", tags={"FragileCode"}, severity=BugPattern.SeverityLevel.WARNING)
public final class AnnotateFormatMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String REORDER = " (The parameters of this method would need to be reordered to make the format string and arguments the final parameters before the @FormatMethod annotation can be used.)";
    private static final Matcher<ExpressionTree> STRING_FORMAT = MethodMatchers.staticMethod().onClass("java.lang.String").named("format");
    private static final Matcher<ExpressionTree> FORMATTED = MethodMatchers.instanceMethod().onExactClass("java.lang.String").named("formatted");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.VarSymbol formatArgs;
        Symbol.VarSymbol formatString;
        if (STRING_FORMAT.matches((Tree)tree, state)) {
            if (tree.getArguments().size() != 2) {
                return Description.NO_MATCH;
            }
            formatString = AnnotateFormatMethod.asSymbol(tree.getArguments().get(0));
            formatArgs = AnnotateFormatMethod.asSymbol(tree.getArguments().get(1));
        } else if (FORMATTED.matches((Tree)tree, state)) {
            if (tree.getArguments().size() != 1) {
                return Description.NO_MATCH;
            }
            formatString = AnnotateFormatMethod.asSymbol(ASTHelpers.getReceiver((ExpressionTree)tree));
            formatArgs = AnnotateFormatMethod.asSymbol(tree.getArguments().get(0));
        } else {
            return Description.NO_MATCH;
        }
        if (formatString == null || formatArgs == null) {
            return Description.NO_MATCH;
        }
        return Streams.stream((Iterable)state.getPath()).flatMap(node -> {
            if (!(node instanceof MethodTree)) {
                return Stream.empty();
            }
            MethodTree methodTree = (MethodTree)node;
            if (!ASTHelpers.getSymbol((MethodTree)methodTree).isVarArgs() || ASTHelpers.hasAnnotation((Tree)methodTree, (String)"com.google.errorprone.annotations.FormatMethod", (VisitorState)state)) {
                return Stream.empty();
            }
            List<? extends VariableTree> enclosingParameters = methodTree.getParameters();
            VariableTree formatParameter = AnnotateFormatMethod.findParameterWithSymbol(enclosingParameters, formatString);
            VariableTree argumentsParameter = AnnotateFormatMethod.findParameterWithSymbol(enclosingParameters, formatArgs);
            if (formatParameter == null || argumentsParameter == null) {
                return Stream.empty();
            }
            if (!argumentsParameter.equals(Iterables.getLast(enclosingParameters))) {
                return Stream.empty();
            }
            boolean fixable = formatParameter.equals(enclosingParameters.get(enclosingParameters.size() - 2));
            return Stream.of(this.buildDescription(methodTree).setMessage((String)(fixable ? this.message() : this.message() + REORDER)).build());
        }).findFirst().orElse(Description.NO_MATCH);
    }

    private static VariableTree findParameterWithSymbol(List<? extends VariableTree> parameters, Symbol symbol) {
        return ((Optional)parameters.stream().filter(parameter -> symbol.equals(ASTHelpers.getSymbol((VariableTree)parameter))).collect(MoreCollectors.toOptional())).orElse(null);
    }

    private static @Nullable Symbol.VarSymbol asSymbol(ExpressionTree tree) {
        Symbol.VarSymbol varSymbol;
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol instanceof Symbol.VarSymbol ? (varSymbol = (Symbol.VarSymbol)symbol) : null;
    }
}

