/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Fields annotated with @Inject/@Mock should not be manually assigned to, as they should be initialized by a framework. Remove the assignment if a framework is being used, or the annotation if one isn't.", severity=BugPattern.SeverityLevel.WARNING)
public final class UnnecessaryAssignment
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableSet<String> FRAMEWORK_ANNOTATIONS = ImmutableSet.of((Object)"com.google.testing.junit.testparameterinjector.TestParameter", (Object)"com.google.inject.Inject", (Object)"jakarta.inject.Inject", (Object)"javax.inject.Inject");
    private static final Matcher<Tree> HAS_MOCK_ANNOTATION = Matchers.symbolHasAnnotation((String)"org.mockito.Mock");
    private static final Matcher<Tree> HAS_NON_MOCK_FRAMEWORK_ANNOTATION = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Iterable)((Iterable)FRAMEWORK_ANNOTATIONS.stream().map(Matchers::symbolHasAnnotation).collect(ImmutableList.toImmutableList()))), Matchers.not(UnnecessaryAssignment::isOptionalInject)});
    private static final Supplier<Symbol> INJECT = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString("com.google.inject.Inject"));
    private static final Matcher<ExpressionTree> MOCK_FACTORY = MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("mock");
    private static final Matcher<ExpressionTree> INITIALIZES_MOCKS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("org.mockito.MockitoAnnotations").named("initMocks")});
    private static final MultiMatcher<ClassTree, AnnotationTree> MOCKITO_RUNNER = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasArgumentWithValue((String)"value", (Matcher)JUnitMatchers.isJUnit4TestRunnerOfType((Iterable)ImmutableList.of((Object)"org.mockito.junit.MockitoJUnitRunner"))));

    private static boolean isOptionalInject(Tree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        Attribute.Compound compound = symbol.attribute((Symbol)INJECT.get(state));
        if (compound == null) {
            return false;
        }
        return MoreAnnotations.getValue((Attribute.Compound)compound, (String)"optional").map(a -> Objects.equals(a.getValue(), true)).orElse(false);
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        SuggestedFix suggestedFix;
        if (!HAS_MOCK_ANNOTATION.matches((Tree)tree.getVariable(), state) && !HAS_NON_MOCK_FRAMEWORK_ANNOTATION.matches((Tree)tree.getVariable(), state)) {
            return Description.NO_MATCH;
        }
        Tree tree2 = state.getPath().getParentPath().getLeaf();
        if (tree2 instanceof ExpressionStatementTree) {
            ExpressionStatementTree est = (ExpressionStatementTree)tree2;
            suggestedFix = SuggestedFix.delete((Tree)est);
        } else {
            suggestedFix = SuggestedFix.emptyFix();
        }
        SuggestedFix fix = suggestedFix;
        return this.describeMatch(tree, (Fix)fix);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        boolean hasMockAnnotation = HAS_MOCK_ANNOTATION.matches((Tree)tree, state);
        boolean hasInjectyAnnotation = HAS_NON_MOCK_FRAMEWORK_ANNOTATION.matches((Tree)tree, state);
        if (hasMockAnnotation && hasInjectyAnnotation) {
            return this.buildDescription(tree).setMessage("Fields shouldn't be annotated with both @Mock and another @Inject-like annotation, because both Mockito and the injector will assign to the field, and one of the values will overwrite the other").build();
        }
        if (tree.getInitializer() == null) {
            return Description.NO_MATCH;
        }
        if (hasMockAnnotation) {
            return this.describeMatch(tree, (Fix)UnnecessaryAssignment.createMockFix(tree, state));
        }
        if (hasInjectyAnnotation) {
            Description.Builder description = this.buildDescription(tree);
            if (!tree.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
                String source = state.getSourceCode().subSequence(ASTHelpers.getStartPosition((Tree)tree), ASTHelpers.getStartPosition((Tree)tree.getInitializer())).toString();
                ImmutableList tokens = ErrorProneTokens.getTokens((String)source, (int)ASTHelpers.getStartPosition((Tree)tree), (Context)state.context);
                int equalsPos = ((ErrorProneToken)Streams.findLast(tokens.stream().filter(t -> t.kind().equals(Tokens.TokenKind.EQ))).get()).pos();
                description.addFix((Fix)SuggestedFix.builder().setShortDescription("Remove the variable's initializer").replace(equalsPos, state.getEndPosition((Tree)tree.getInitializer()), "").build());
            }
            AnnotationTree annotationToRemove = tree.getModifiers().getAnnotations().stream().filter(anno -> FRAMEWORK_ANNOTATIONS.stream().anyMatch(fanno -> ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)anno), (Type)state.getTypeFromString(fanno), (VisitorState)state))).findFirst().get();
            return description.setMessage(String.format("Fields annotated with @%s should not be manually assigned to, as they should be initialized by a framework. Remove the assignment if a framework is being used, or the annotation if one isn't.", ASTHelpers.getType((Tree)annotationToRemove).tsym.getSimpleName())).addFix((Fix)SuggestedFix.builder().setShortDescription("Remove the annotation").delete((Tree)annotationToRemove).build()).build();
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix createMockFix(VariableTree tree, VisitorState state) {
        if (MOCK_FACTORY.matches((Tree)tree.getInitializer(), state) && !UnnecessaryAssignment.classContainsInitializer((ClassTree)state.findEnclosing(new Class[]{ClassTree.class}), state)) {
            AnnotationTree anno = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"Mock");
            return SuggestedFix.delete((Tree)anno);
        }
        int startPos = ASTHelpers.getStartPosition((Tree)tree);
        ImmutableList tokens = state.getOffsetTokens(startPos, ASTHelpers.getStartPosition((Tree)tree.getInitializer()));
        for (ErrorProneToken token : Lists.reverse((List)tokens)) {
            if (token.kind() != Tokens.TokenKind.EQ) continue;
            return SuggestedFix.replace((int)token.pos(), (int)state.getEndPosition((Tree)tree.getInitializer()), (String)"");
        }
        return SuggestedFix.emptyFix();
    }

    private static boolean classContainsInitializer(ClassTree classTree, final VisitorState state) {
        final AtomicBoolean initialized = new AtomicBoolean(false);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                if (MOCKITO_RUNNER.matches((Tree)classTree, state)) {
                    initialized.set(true);
                    return null;
                }
                return (Void)super.visitClass(classTree, null);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void unused) {
                if (INITIALIZES_MOCKS.matches((Tree)methodInvocationTree, state)) {
                    initialized.set(true);
                    return null;
                }
                return (Void)super.visitMethodInvocation(methodInvocationTree, null);
            }

            @Override
            public Void visitNewClass(NewClassTree newClassTree, Void unused) {
                if (INITIALIZES_MOCKS.matches((Tree)newClassTree, state)) {
                    initialized.set(true);
                    return null;
                }
                return (Void)super.visitNewClass(newClassTree, null);
            }
        }.scan(classTree, null);
        return initialized.get();
    }
}

