/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.io.Serializable;
import java.util.Collection;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Using @Test(expected=...) is discouraged, since the test will pass if *any* statement in the test method throws the expected exception", severity=BugPattern.SeverityLevel.ERROR)
public class TestExceptionChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Supplier<Type> ORG_JUNIT_TEST = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("org.junit.Test"));

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder baseFixBuilder = SuggestedFix.builder();
        JCTree.JCExpression expectedException = TestExceptionChecker.deleteExpectedException(baseFixBuilder, ((JCTree.JCMethodDecl)tree).getModifiers().getAnnotations(), state);
        SuggestedFix baseFix = baseFixBuilder.build();
        if (expectedException == null) {
            return Description.NO_MATCH;
        }
        return this.handleStatements(tree, state, expectedException, baseFix);
    }

    private Description handleStatements(MethodTree tree, VisitorState state, JCTree.JCExpression expectedException, SuggestedFix baseFix) {
        return this.describeMatch(tree, (Fix)TestExceptionChecker.buildFix(state, baseFix.toBuilder(), expectedException, tree.getBody().getStatements()));
    }

    private static SuggestedFix buildFix(VisitorState state, SuggestedFix.Builder fix, JCTree.JCExpression expectedException, Collection<? extends StatementTree> statements) {
        if (statements.isEmpty()) {
            return fix.build();
        }
        fix.addStaticImport("org.junit.Assert.assertThrows");
        StringBuilder prefix = new StringBuilder();
        prefix.append(String.format("assertThrows(%s, () -> ", state.getSourceForNode((Tree)expectedException)));
        StatementTree last = (StatementTree)Iterables.getLast(statements);
        if (last instanceof ExpressionStatementTree) {
            ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)last;
            ExpressionTree expression = expressionStatementTree.getExpression();
            fix.prefixWith((Tree)expression, prefix.toString());
            fix.postfixWith((Tree)expression, ")");
        } else {
            prefix.append(" {");
            fix.prefixWith((Tree)last, prefix.toString());
            fix.postfixWith((Tree)last, "});");
        }
        return fix.build();
    }

    private static  @Nullable JCTree.JCExpression deleteExpectedException(SuggestedFix.Builder fix, java.util.List<JCTree.JCAnnotation> annotations, VisitorState state) {
        Type testAnnotation = (Type)ORG_JUNIT_TEST.get(state);
        for (JCTree.JCAnnotation annotationTree : annotations) {
            if (!ASTHelpers.isSameType((Type)testAnnotation, (Type)annotationTree.type, (VisitorState)state)) continue;
            java.util.List arguments = annotationTree.getArguments();
            for (JCTree.JCExpression arg : arguments) {
                if (!arg.hasTag(JCTree.Tag.ASSIGN)) continue;
                JCTree.JCAssign assign = (JCTree.JCAssign)arg;
                if (!assign.lhs.hasTag(JCTree.Tag.IDENT) || !((JCTree.JCIdent)assign.lhs).getName().contentEquals("expected")) continue;
                if (((List)arguments).size() == 1) {
                    fix.replace((Tree)annotationTree, "@" + SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"org.junit.Test"));
                } else {
                    TestExceptionChecker.removeFromList(fix, state, arguments, assign);
                }
                return assign.rhs;
            }
        }
        return null;
    }

    private static void removeFromList(SuggestedFix.Builder fix, VisitorState state, java.util.List<? extends Tree> arguments, Tree tree) {
        int idx = arguments.indexOf(tree);
        if (idx == arguments.size() - 1) {
            fix.replace(state.getEndPosition(arguments.get(arguments.size() - 1)), state.getEndPosition(tree), "");
        } else {
            fix.replace(ASTHelpers.getStartPosition((Tree)tree), ASTHelpers.getStartPosition((Tree)arguments.get(idx + 1)), "");
        }
    }
}

