/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@BugPattern(summary="StringCharset", severity=BugPattern.SeverityLevel.WARNING, explanation="Prefer StandardCharsets over using string names for charsets")
public class StringCharset
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> CONSTRUCTOR_MATCHER = Matchers.constructor().forClass("java.lang.String").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.arrayOf((Supplier)Suppliers.BYTE_TYPE), (Object)Suppliers.STRING_TYPE));
    private static final Matcher<ExpressionTree> METHOD_MATCHER = Matchers.instanceMethod().onExactClass("java.lang.String").named("getBytes").withParameters("java.lang.String", new String[0]);
    private static final ImmutableSet<Charset> CHARSETS = ImmutableSet.of((Object)StandardCharsets.UTF_8, (Object)StandardCharsets.ISO_8859_1, (Object)StandardCharsets.US_ASCII, (Object)StandardCharsets.UTF_16, (Object)StandardCharsets.UTF_16BE, (Object)StandardCharsets.UTF_16LE, (Object[])new Charset[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!METHOD_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.match(tree.getArguments().get(0), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!CONSTRUCTOR_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.match(tree.getArguments().get(1), state);
    }

    private Description match(ExpressionTree tree, VisitorState state) {
        Charset charset;
        String value = (String)ASTHelpers.constValue((Tree)tree, String.class);
        if (value == null) {
            return Description.NO_MATCH;
        }
        try {
            charset = Charset.forName(value);
        }
        catch (IllegalArgumentException e) {
            return this.buildDescription(tree).setMessage(String.format("%s is not a valid charset", value)).build();
        }
        if (!CHARSETS.contains((Object)charset)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace((Tree)tree, SuggestedFixes.qualifyStaticImport((String)("java.nio.charset.StandardCharsets." + charset.name().replace('-', '_')), (SuggestedFix.Builder)fix, (VisitorState)state));
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

