/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractMethodReturnsNull;
import com.google.errorprone.dataflow.nullnesspropagation.TrustingNullnessAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;

@BugPattern(summary="Method has a collection return type and returns {@code null} in some cases but does not annotate the method as @Nullable. See Effective Java 3rd Edition Item 54.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class ReturnsNullCollection
extends AbstractMethodReturnsNull {
    private static final Matcher<MethodTree> METHOD_RETURNS_COLLECTION_WITHOUT_NULLABLE_ANNOTATION = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.methodReturns((Matcher)Matchers.isSubtypeOf((String)"java.util.Collection")), Matchers.methodReturns((Matcher)Matchers.isSubtypeOf((String)"java.util.Map")), Matchers.methodReturns((Matcher)Matchers.isSubtypeOf((String)"com.google.common.collect.Multimap")), Matchers.methodReturns((Matcher)Matchers.isSubtypeOf((String)"com.google.common.collect.Table"))}), ReturnsNullCollection::methodWithoutNullable});

    private static boolean methodWithoutNullable(MethodTree tree, VisitorState state) {
        return !TrustingNullnessAnalysis.hasNullableAnnotation((Symbol)ASTHelpers.getSymbol((MethodTree)tree));
    }

    public ReturnsNullCollection() {
        super(METHOD_RETURNS_COLLECTION_WITHOUT_NULLABLE_ANNOTATION);
    }

    @Override
    protected Optional<Fix> provideFix(ReturnTree tree) {
        return Optional.empty();
    }
}

