/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.names.LevenshteinEditDistance;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class ReplacementVariableFinder {
    private ReplacementVariableFinder() {
    }

    public static ImmutableList<Fix> fixesByReplacingExpressionWithLocallyDeclaredField(ExpressionTree input, Predicate<JCTree.JCVariableDecl> validFieldPredicate, VisitorState state) {
        Preconditions.checkState((input instanceof IdentifierTree || input instanceof MemberSelectTree ? 1 : 0) != 0);
        ImmutableMultimap<Integer, JCTree.JCVariableDecl> potentialReplacements = ((JCTree.JCClassDecl)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), JCTree.JCClassDecl.class)).getMembers().stream().filter(JCTree.JCVariableDecl.class::isInstance).map(JCTree.JCVariableDecl.class::cast).filter(validFieldPredicate).collect(ReplacementVariableFinder.collectByEditDistanceTo(ReplacementVariableFinder.simpleNameOfIdentifierOrMemberAccess(input)));
        return ReplacementVariableFinder.buildValidReplacements(potentialReplacements, var -> SuggestedFix.replace((Tree)input, (String)("this." + String.valueOf(var.sym))));
    }

    public static ImmutableList<Fix> fixesByReplacingExpressionWithMethodParameter(ExpressionTree input, Predicate<JCTree.JCVariableDecl> validParameterPredicate, VisitorState state) {
        Preconditions.checkState((input instanceof IdentifierTree || input instanceof MemberSelectTree ? 1 : 0) != 0);
        JCTree.JCMethodDecl methodTree = (JCTree.JCMethodDecl)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), JCTree.JCMethodDecl.class);
        if (methodTree == null) {
            return ImmutableList.of();
        }
        ImmutableMultimap<Integer, JCTree.JCVariableDecl> potentialReplacements = methodTree.getParameters().stream().filter(validParameterPredicate).collect(ReplacementVariableFinder.collectByEditDistanceTo(ReplacementVariableFinder.simpleNameOfIdentifierOrMemberAccess(input)));
        return ReplacementVariableFinder.buildValidReplacements(potentialReplacements, var -> SuggestedFix.replace((Tree)input, (String)var.sym.toString()));
    }

    private static ImmutableList<Fix> buildValidReplacements(Multimap<Integer, JCTree.JCVariableDecl> potentialReplacements, Function<JCTree.JCVariableDecl, Fix> replacementFunction) {
        if (potentialReplacements.isEmpty()) {
            return ImmutableList.of();
        }
        return (ImmutableList)potentialReplacements.get((Object)((Integer)Collections.min(potentialReplacements.keySet()))).stream().map(replacementFunction).collect(ImmutableList.toImmutableList());
    }

    private static Collector<JCTree.JCVariableDecl, ?, ImmutableMultimap<Integer, JCTree.JCVariableDecl>> collectByEditDistanceTo(String baseName) {
        return Collectors.collectingAndThen(Multimaps.toMultimap(varDecl -> LevenshteinEditDistance.getEditDistance((String)baseName, (String)varDecl.name.toString()), varDecl -> varDecl, LinkedHashMultimap::create), ImmutableMultimap::copyOf);
    }

    private static String simpleNameOfIdentifierOrMemberAccess(ExpressionTree tree) {
        String name = null;
        if (tree instanceof IdentifierTree) {
            name = ((JCTree.JCIdent)tree).name.toString();
        } else if (tree instanceof MemberSelectTree) {
            name = ((JCTree.JCFieldAccess)tree).name.toString();
        }
        return name;
    }
}

