/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

@BugPattern(summary="Overloads will be ambiguous when passing lambda arguments.", severity=BugPattern.SeverityLevel.WARNING)
public class FunctionalInterfaceClash
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol origin = ASTHelpers.getSymbol((ClassTree)tree);
        Types types = state.getTypes();
        HashMultimap methodsByName = HashMultimap.create();
        for (Symbol sym : types.membersClosure(ASTHelpers.getType((ClassTree)tree), false).getSymbols()) {
            Symbol.MethodSymbol methodSymbol2;
            if (!(sym instanceof Symbol.MethodSymbol) || (methodSymbol2 = (Symbol.MethodSymbol)sym).getParameters().stream().noneMatch(p -> FunctionalInterfaceClash.maybeFunctionalInterface(p.type, types, state)) || methodSymbol2.isConstructor() && !methodSymbol2.owner.equals(origin)) continue;
            methodsByName.put((Object)((Name)methodSymbol2.getSimpleName()).toString(), (Object)methodSymbol2);
        }
        HashMultimap methodsBySignature = HashMultimap.create();
        for (Symbol.MethodSymbol methodSymbol3 : methodsByName.values()) {
            if (methodsByName.get((Object)((Name)methodSymbol3.getSimpleName()).toString()).stream().anyMatch(o -> !msym.overrides((Symbol)o, (Symbol.TypeSymbol)msym.owner, types, true) && !o.equals(msym) && ((List)o.getParameters()).length() == ((List)msym.getParameters()).length() && Streams.zip(msym.getParameters().stream(), o.getParameters().stream(), (a, b) -> ASTHelpers.isSubtype((Type)a.type, (Type)b.type, (VisitorState)state)).allMatch(x -> x))) continue;
            methodsBySignature.put((Object)FunctionalInterfaceClash.functionalInterfaceSignature(state, methodSymbol3), (Object)methodSymbol3);
        }
        for (Tree tree2 : tree.getMembers()) {
            MethodTree methodTree;
            Symbol.MethodSymbol msym;
            if (!(tree2 instanceof MethodTree) || (msym = ASTHelpers.getSymbol((MethodTree)(methodTree = (MethodTree)tree2))).getParameters().stream().noneMatch(p -> FunctionalInterfaceClash.maybeFunctionalInterface(p.type, types, state))) continue;
            ArrayList clash = new ArrayList(methodsBySignature.removeAll((Object)FunctionalInterfaceClash.functionalInterfaceSignature(state, msym)));
            ArrayDeque<Symbol.MethodSymbol> worklist = new ArrayDeque<Symbol.MethodSymbol>();
            worklist.push(msym);
            clash.remove(msym);
            while (!worklist.isEmpty()) {
                Symbol.MethodSymbol msym2 = (Symbol.MethodSymbol)worklist.removeFirst();
                ImmutableList overrides = (ImmutableList)clash.stream().filter(m -> msym2.overrides((Symbol)m, origin, types, false)).collect(ImmutableList.toImmutableList());
                worklist.addAll((Collection<Symbol.MethodSymbol>)overrides);
                clash.removeAll((Collection<?>)overrides);
            }
            if (clash.isEmpty() || ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)msym, (Types)types).anyMatch(t -> !t.owner.isInterface()) && clash.stream().anyMatch(methodSymbol -> ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)types).anyMatch(t -> !t.owner.isInterface())) || this.isSuppressed(tree2, state)) continue;
            String message = "When passing lambda arguments to this function, callers will need a cast to disambiguate with: " + clash.stream().map(m -> "\n    " + Signatures.prettyMethodSignature((Symbol.ClassSymbol)origin, (Symbol.MethodSymbol)m)).sorted().collect(Collectors.joining(""));
            state.reportMatch(this.buildDescription(tree2).setMessage(message).build());
        }
        return Description.NO_MATCH;
    }

    private static String functionalInterfaceSignature(VisitorState state, Symbol.MethodSymbol msym) {
        return String.format("%s(%s)", msym.getSimpleName(), msym.getParameters().stream().map(p -> FunctionalInterfaceClash.functionalInterfaceSignature(state, p.type)).collect(Collectors.joining(",")));
    }

    private static String functionalInterfaceSignature(VisitorState state, Type type) {
        Types types = state.getTypes();
        if (!FunctionalInterfaceClash.maybeFunctionalInterface(type, types, state)) {
            return Signatures.descriptor((Type)type, (VisitorState)state);
        }
        Type descriptorType = types.findDescriptorType(type);
        List<Type> fiparams = descriptorType.getParameterTypes();
        String result = fiparams.isEmpty() ? Signatures.descriptor((Type)descriptorType.getReturnType(), (VisitorState)state) : "_";
        return String.format("(%s)->%s", fiparams.stream().map(t -> Signatures.descriptor((Type)t, (VisitorState)state)).collect(Collectors.joining(",")), result);
    }

    private static boolean maybeFunctionalInterface(Type type, Types types, VisitorState state) {
        try {
            return types.isFunctionalInterface(type);
        }
        catch (Symbol.CompletionFailure e) {
            Check.instance(state.context).completionError((JCDiagnostic.DiagnosticPosition)((Object)state.getPath().getLeaf()), e);
            return false;
        }
    }
}

