/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.Iterator;
import java.util.Optional;
import javax.lang.model.type.TypeKind;

public abstract class AbstractToString
extends BugChecker
implements BugChecker.BinaryTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.CompoundAssignmentTreeMatcher {
    private static final Matcher<ExpressionTree> TO_STRING = Matchers.instanceMethod().anyClass().named("toString").withNoParameters();
    private static final Matcher<ExpressionTree> FLOGGER_LOG = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log");
    private static final Matcher<ExpressionTree> FORMAT_METHOD = Matchers.symbolHasAnnotation(FormatMethod.class);
    private static final Matcher<ExpressionTree> STRING_FORMAT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.lang.String").named("format"), Matchers.instanceMethod().onExactClass("java.lang.String").named("formatted")});
    private static final Matcher<ExpressionTree> VALUE_OF = Matchers.staticMethod().onClass("java.lang.String").named("valueOf").withParameters("java.lang.Object", new String[0]);
    private static final Matcher<ExpressionTree> PRINT_STRING = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.io.PrintStream").namedAnyOf(new String[]{"print", "println"}).withParameters("java.lang.Object", new String[0]), Matchers.instanceMethod().onExactClass("java.lang.StringBuilder").named("append").withParameters("java.lang.Object", new String[0])});
    private static final Matcher<ExpressionTree> JOINER = Matchers.instanceMethod().onDescendantOf("com.google.common.base.Joiner").named("join");
    private final boolean handleJoiner;

    protected abstract TypePredicate typePredicate();

    protected abstract Optional<Fix> implicitToStringFix(ExpressionTree var1, VisitorState var2);

    protected Optional<String> descriptionMessageForDefaultMatch(Type type, VisitorState state) {
        return Optional.empty();
    }

    protected boolean allowableToStringKind(ToStringKind toStringKind) {
        return false;
    }

    protected abstract Optional<Fix> toStringFix(Tree var1, ExpressionTree var2, VisitorState var3);

    protected AbstractToString(ErrorProneFlags flags) {
        this.handleJoiner = flags.getBoolean("AbstractToString:Joiner").orElse(true);
    }

    private static boolean isInVarargsPosition(ExpressionTree argTree, MethodInvocationTree methodInvocationTree, VisitorState state) {
        int parameterCount = ((List)ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree).getParameters()).size();
        java.util.List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        return (arguments.size() > parameterCount || !state.getTypes().isArray(ASTHelpers.getType((Tree)argTree))) && arguments.indexOf(argTree) >= parameterCount - 1;
    }

    private static boolean isVarargsArray(ExpressionTree argTree, MethodInvocationTree methodInvocationTree, VisitorState state) {
        int parameterCount = ((List)ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree).getParameters()).size();
        java.util.List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        return arguments.size() == parameterCount && state.getTypes().isArray(ASTHelpers.getType((Tree)argTree)) && arguments.indexOf(argTree) == parameterCount - 1;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol;
        Iterator<? extends ExpressionTree> receiver;
        if (PRINT_STRING.matches((Tree)tree, state)) {
            for (ExpressionTree expressionTree : tree.getArguments()) {
                this.handleStringifiedTree(expressionTree, ToStringKind.IMPLICIT, state);
            }
        }
        if (VALUE_OF.matches((Tree)tree, state)) {
            for (ExpressionTree expressionTree : tree.getArguments()) {
                this.handleStringifiedTree(tree, expressionTree, ToStringKind.EXPLICIT, state.withPath(new TreePath(state.getPath(), expressionTree)));
            }
        }
        if (TO_STRING.matches((Tree)tree, state) && (receiver = ASTHelpers.getReceiver((ExpressionTree)tree)) != null) {
            this.handleStringifiedTree(tree, (ExpressionTree)((Object)receiver), ToStringKind.EXPLICIT, state);
        }
        if (FORMAT_METHOD.matches((Tree)tree, state)) {
            for (ExpressionTree expressionTree : tree.getArguments()) {
                if (!AbstractToString.isInVarargsPosition(expressionTree, tree, state)) continue;
                this.handleStringifiedTree(expressionTree, ToStringKind.FORMAT_METHOD, state);
            }
        }
        if (STRING_FORMAT.matches((Tree)tree, state)) {
            for (ExpressionTree expressionTree : tree.getArguments()) {
                if (!AbstractToString.isInVarargsPosition(expressionTree, tree, state)) continue;
                this.handleStringifiedTree(expressionTree, ToStringKind.IMPLICIT, state);
            }
        }
        if (FLOGGER_LOG.matches((Tree)tree, state)) {
            for (ExpressionTree expressionTree : tree.getArguments()) {
                this.handleStringifiedTree(expressionTree, ToStringKind.FLOGGER, state);
            }
        }
        if (this.handleJoiner && JOINER.matches((Tree)tree, state) && (symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree)).isVarArgs()) {
            for (ExpressionTree expressionTree : tree.getArguments()) {
                if (AbstractToString.isVarargsArray(expressionTree, tree, state)) {
                    this.handleStringifiedTree(((Type.ArrayType)ASTHelpers.getType((Tree)expressionTree)).getComponentType(), expressionTree, expressionTree, ToStringKind.IMPLICIT, state);
                    continue;
                }
                this.handleStringifiedTree(expressionTree, ToStringKind.IMPLICIT, state);
            }
        }
        return Description.NO_MATCH;
    }

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!state.getTypes().isSameType(ASTHelpers.getType((Tree)tree), state.getSymtab().stringType)) {
            return Description.NO_MATCH;
        }
        if (tree.getKind() == Tree.Kind.PLUS) {
            this.handleStringifiedTree(tree.getLeftOperand(), ToStringKind.IMPLICIT, state);
            this.handleStringifiedTree(tree.getRightOperand(), ToStringKind.IMPLICIT, state);
        }
        if (tree.getKind() == Tree.Kind.PLUS_ASSIGNMENT) {
            this.handleStringifiedTree(tree.getRightOperand(), ToStringKind.IMPLICIT, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        if (state.getTypes().isSameType(ASTHelpers.getType((Tree)tree.getVariable()), state.getSymtab().stringType) && tree.getKind() == Tree.Kind.PLUS_ASSIGNMENT) {
            this.handleStringifiedTree(tree.getExpression(), ToStringKind.IMPLICIT, state);
        }
        return Description.NO_MATCH;
    }

    private void handleStringifiedTree(ExpressionTree tree, ToStringKind toStringKind, VisitorState state) {
        this.handleStringifiedTree(tree, tree, toStringKind, state);
    }

    private void handleStringifiedTree(Tree parent, ExpressionTree tree, ToStringKind toStringKind, VisitorState state) {
        this.handleStringifiedTree(AbstractToString.type(tree), parent, tree, toStringKind, state);
    }

    private void handleStringifiedTree(Type type, Tree parent, ExpressionTree tree, ToStringKind toStringKind, VisitorState state) {
        if (type.getKind() == TypeKind.NULL || !this.typePredicate().apply(type, state) || this.allowableToStringKind(toStringKind)) {
            return;
        }
        state.reportMatch(this.maybeFix(tree, state, type, this.getFix(tree, state, parent, toStringKind)));
    }

    private static Type type(ExpressionTree tree) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (type instanceof Type.MethodType) {
            return type.getReturnType();
        }
        return type;
    }

    private Optional<Fix> getFix(ExpressionTree tree, VisitorState state, Tree parent, ToStringKind toStringKind) {
        switch (toStringKind.ordinal()) {
            case 0: 
            case 2: 
            case 3: {
                return this.implicitToStringFix(tree, state);
            }
            case 1: {
                return this.toStringFix(parent, tree, state);
            }
        }
        throw new AssertionError();
    }

    private Description maybeFix(Tree tree, VisitorState state, Type matchedType, Optional<Fix> fix) {
        Description.Builder description = this.buildDescription(tree);
        fix.ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
        this.descriptionMessageForDefaultMatch(matchedType, state).ifPresent(arg_0 -> ((Description.Builder)description).setMessage(arg_0));
        return description.build();
    }

    static enum ToStringKind {
        IMPLICIT,
        EXPLICIT,
        FORMAT_METHOD,
        FLOGGER,
        NONE;

    }
}

