/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.PrintWriter;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.SimpleUsageMarker;
import proguard.util.Processable;

public class UsagePrinter
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final SimpleUsageMarker usageMarker;
    private final boolean printUnusedItems;
    private final PrintWriter pw;
    private String className;

    public UsagePrinter(SimpleUsageMarker usageMarker, boolean printUnusedItems, PrintWriter printWriter) {
        this.usageMarker = usageMarker;
        this.printUnusedItems = printUnusedItems;
        this.pw = printWriter;
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (this.usageMarker.isUsed((Processable)programClass)) {
            if (this.printUnusedItems) {
                this.className = programClass.getName();
                programClass.fieldsAccept((MemberVisitor)this);
                programClass.methodsAccept((MemberVisitor)this);
                this.className = null;
            } else {
                this.pw.println(ClassUtil.externalClassName((String)programClass.getName()));
            }
        } else if (this.printUnusedItems) {
            this.pw.println(ClassUtil.externalClassName((String)programClass.getName()));
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.usageMarker.isUsed((Processable)programField) ^ this.printUnusedItems) {
            this.printClassNameHeader();
            this.pw.println("    " + ClassUtil.externalFullFieldDescription((int)programField.getAccessFlags(), (String)programField.getName((Clazz)programClass), (String)programField.getDescriptor((Clazz)programClass)));
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.usageMarker.isUsed((Processable)programMethod) ^ this.printUnusedItems) {
            this.printClassNameHeader();
            this.pw.print("    ");
            programMethod.attributesAccept(programClass, (AttributeVisitor)this);
            this.pw.println(ClassUtil.externalFullMethodDescription((String)programClass.getName(), (int)programMethod.getAccessFlags(), (String)programMethod.getName((Clazz)programClass), (String)programMethod.getDescriptor((Clazz)programClass)));
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, (AttributeVisitor)this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.pw.print(lineNumberTableAttribute.getLowestLineNumber() + ":" + lineNumberTableAttribute.getHighestLineNumber() + ":");
    }

    private void printClassNameHeader() {
        if (this.className != null) {
            this.pw.println(ClassUtil.externalClassName((String)this.className) + ":");
            this.className = null;
        }
    }
}

