/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.pass.Pass;

public class AfterInitConfigurationVerifier
implements Pass {
    private final Configuration configuration;
    private static final Logger logger = LogManager.getLogger(AfterInitConfigurationVerifier.class);

    public AfterInitConfigurationVerifier(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) {
        if (this.configuration.targetClassVersion != 0) {
            appView.programClassPool.classesAccept((ClassVisitor)new BackportMaxVersionVisitor(0x370000, this.configuration.targetClassVersion));
        }
    }

    private static class BackportMaxVersionVisitor
    implements ClassVisitor {
        private final int maxClassFileVersion;
        private final int target;

        private BackportMaxVersionVisitor(int maxClassFileVersion, int target) {
            this.maxClassFileVersion = maxClassFileVersion;
            this.target = target;
        }

        public void visitProgramClass(ProgramClass programClass) {
            if (programClass.u4version > this.maxClassFileVersion) {
                if (programClass.u4version != this.target) {
                    throw new RuntimeException("-target can only be used with class file versions <= " + ClassUtil.internalMajorClassVersion((int)this.maxClassFileVersion) + " (Java " + ClassUtil.externalClassVersion((int)this.maxClassFileVersion) + ")." + System.lineSeparator() + "The input classes contain version " + ClassUtil.internalMajorClassVersion((int)programClass.u4version) + " class files which cannot be backported to target version (" + ClassUtil.internalMajorClassVersion((int)this.target) + ").");
                }
                logger.warn("-target is deprecated when using class file above " + ClassUtil.internalMajorClassVersion((int)this.maxClassFileVersion) + " (Java " + ClassUtil.externalClassVersion((int)this.maxClassFileVersion) + ").");
            }
        }

        public void visitAnyClass(Clazz clazz) {
        }
    }
}

