/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UselessViewDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(UselessViewDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue USELESS_PARENT = Issue.create((String)"UselessParent", (String)"Useless parent layout", (String)"A layout with children that has no siblings, is not a scrollview or a root layout, and does not have a background, can be removed and have its children moved directly into the parent for a flatter and more efficient layout hierarchy.", (Category)Category.PERFORMANCE, (int)2, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue USELESS_LEAF = Issue.create((String)"UselessLeaf", (String)"Useless leaf layout", (String)"A layout that has no children or no background can often be removed (since it is invisible) for a flatter and more efficient layout hierarchy.", (Category)Category.PERFORMANCE, (int)2, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    private static final List<String> CONTAINERS = new ArrayList<String>(18);

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return CONTAINERS;
    }

    public void visitElement(XmlContext context, Element element) {
        int childCount = LintUtils.getChildCount((Node)element);
        if (childCount == 0) {
            UselessViewDetector.checkUselessLeaf(context, element);
        } else {
            UselessViewDetector.checkUselessMiddleLayout(context, element);
        }
    }

    private static void checkUselessMiddleLayout(XmlContext context, Element element) {
        Node parentNode = element.getParentNode();
        if (parentNode.getNodeType() != 1) {
            return;
        }
        Element parent = (Element)parentNode;
        String parentTag = parent.getTagName();
        if (parentTag.equals("ScrollView") || parentTag.equals("HorizontalScrollView") || parentTag.equals("merge")) {
            return;
        }
        assert (LintUtils.getChildCount((Node)element) > 0);
        int parentChildCount = LintUtils.getChildCount((Node)parent);
        if (parentChildCount != 1) {
            return;
        }
        boolean nodeHasBackground = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background");
        boolean parentHasBackground = parent.hasAttributeNS("http://schemas.android.com/apk/res/android", "background");
        if (nodeHasBackground && parentHasBackground) {
            return;
        }
        if (!CONTAINERS.contains(parentTag)) {
            return;
        }
        if (parentHasBackground && element.hasAttributeNS("http://schemas.android.com/apk/res/android", "padding") || element.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingLeft") || element.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingRight") || element.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingTop") || element.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingBottom") || element.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingStart") || element.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingEnd")) {
            return;
        }
        boolean hasId = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "id");
        Location location = context.getLocation((Node)element);
        String tag = element.getTagName();
        String format = hasId ? "This `%1$s` layout or its `%2$s` parent is possibly useless" : "This `%1$s` layout or its `%2$s` parent is useless";
        if (nodeHasBackground || parentHasBackground) {
            format = format + "; transfer the `background` attribute to the other view";
        }
        String message = String.format(format, tag, parentTag);
        context.report(USELESS_PARENT, (Node)element, location, message);
    }

    private static void checkUselessLeaf(XmlContext context, Element element) {
        assert (LintUtils.getChildCount((Node)element) == 0);
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "id")) {
            return;
        }
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background")) {
            return;
        }
        if (element.hasAttribute("style")) {
            return;
        }
        if (element == context.document.getDocumentElement()) {
            return;
        }
        Location location = context.getLocation((Node)element);
        String tag = element.getTagName();
        String message = String.format("This `%1$s` view is useless (no children, no `background`, no `id`, no `style`)", tag);
        context.report(USELESS_LEAF, (Node)element, location, message);
    }

    static {
        CONTAINERS.add("AbsoluteLayout");
        CONTAINERS.add("FrameLayout");
        CONTAINERS.add("GridLayout");
        CONTAINERS.add("GridView");
        CONTAINERS.add("HorizontalScrollView");
        CONTAINERS.add("ImageSwitcher");
        CONTAINERS.add("LinearLayout");
        CONTAINERS.add("RadioGroup");
        CONTAINERS.add("RelativeLayout");
        CONTAINERS.add("ScrollView");
        CONTAINERS.add("SlidingDrawer");
        CONTAINERS.add("StackView");
        CONTAINERS.add("TableLayout");
        CONTAINERS.add("TableRow");
        CONTAINERS.add("TextSwitcher");
        CONTAINERS.add("ViewAnimator");
        CONTAINERS.add("ViewFlipper");
        CONTAINERS.add("ViewSwitcher");
    }
}

