/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.ast.AstVisitor;
import lombok.ast.Cast;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;

public class ServiceCastDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"ServiceCast", (String)"Wrong system service casts", (String)"When you call `Context#getSystemService()`, the result is typically cast to a specific interface. This lint check ensures that the cast is compatible with the expected type of the return value.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)new Implementation(ServiceCastDetector.class, Scope.JAVA_FILE_SCOPE));
    private static Map<String, String> sServiceMap;

    public boolean appliesTo(Context context, File file) {
        return true;
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("getSystemService");
    }

    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation node) {
        if (node.getParent() instanceof Cast) {
            String name;
            String expectedClass;
            Cast cast = (Cast)node.getParent();
            StrictListAccessor args = node.astArguments();
            if (args.size() == 1 && (expectedClass = ServiceCastDetector.getExpectedType(name = ServiceCastDetector.stripPackage(((Expression)args.first()).toString()))) != null) {
                String castType = cast.astTypeReference().getTypeName();
                if (castType.indexOf(46) == -1) {
                    expectedClass = ServiceCastDetector.stripPackage(expectedClass);
                }
                if (!castType.equals(expectedClass)) {
                    if (ServiceCastDetector.isClipboard(castType) && ServiceCastDetector.isClipboard(expectedClass)) {
                        return;
                    }
                    String message = String.format("Suspicious cast to `%1$s` for a `%2$s`: expected `%3$s`", ServiceCastDetector.stripPackage(castType), name, ServiceCastDetector.stripPackage(expectedClass));
                    context.report(ISSUE, (Node)node, context.getLocation((Node)cast), message);
                }
            }
        }
    }

    private static boolean isClipboard(String cls) {
        return cls.equals("android.content.ClipboardManager") || cls.equals("android.text.ClipboardManager");
    }

    private static String stripPackage(String fqcn) {
        int index = fqcn.lastIndexOf(46);
        if (index != -1) {
            fqcn = fqcn.substring(index + 1);
        }
        return fqcn;
    }

    private static String getExpectedType(String value) {
        return ServiceCastDetector.getServiceMap().get(value);
    }

    private static Map<String, String> getServiceMap() {
        if (sServiceMap == null) {
            int EXPECTED_SIZE = 55;
            sServiceMap = Maps.newHashMapWithExpectedSize((int)55);
            sServiceMap.put("ACCESSIBILITY_SERVICE", "android.view.accessibility.AccessibilityManager");
            sServiceMap.put("ACCOUNT_SERVICE", "android.accounts.AccountManager");
            sServiceMap.put("ACTIVITY_SERVICE", "android.app.ActivityManager");
            sServiceMap.put("ALARM_SERVICE", "android.app.AlarmManager");
            sServiceMap.put("APPWIDGET_SERVICE", "android.appwidget.AppWidgetManager");
            sServiceMap.put("APP_OPS_SERVICE", "android.app.AppOpsManager");
            sServiceMap.put("AUDIO_SERVICE", "android.media.AudioManager");
            sServiceMap.put("BATTERY_SERVICE", "android.os.BatteryManager");
            sServiceMap.put("BLUETOOTH_SERVICE", "android.bluetooth.BluetoothManager");
            sServiceMap.put("CAMERA_SERVICE", "android.hardware.camera2.CameraManager");
            sServiceMap.put("CAPTIONING_SERVICE", "android.view.accessibility.CaptioningManager");
            sServiceMap.put("CARRIER_CONFIG_SERVICE", "android.telephony.CarrierConfigManager");
            sServiceMap.put("CLIPBOARD_SERVICE", "android.text.ClipboardManager");
            sServiceMap.put("CONNECTIVITY_SERVICE", "android.net.ConnectivityManager");
            sServiceMap.put("CONSUMER_IR_SERVICE", "android.hardware.ConsumerIrManager");
            sServiceMap.put("DEVICE_POLICY_SERVICE", "android.app.admin.DevicePolicyManager");
            sServiceMap.put("DISPLAY_SERVICE", "android.hardware.display.DisplayManager");
            sServiceMap.put("DOWNLOAD_SERVICE", "android.app.DownloadManager");
            sServiceMap.put("DROPBOX_SERVICE", "android.os.DropBoxManager");
            sServiceMap.put("FINGERPRINT_SERVICE", "android.hardware.fingerprint.FingerprintManager");
            sServiceMap.put("INPUT_METHOD_SERVICE", "android.view.inputmethod.InputMethodManager");
            sServiceMap.put("INPUT_SERVICE", "android.hardware.input.InputManager");
            sServiceMap.put("JOB_SCHEDULER_SERVICE", "android.app.job.JobScheduler");
            sServiceMap.put("KEYGUARD_SERVICE", "android.app.KeyguardManager");
            sServiceMap.put("LAUNCHER_APPS_SERVICE", "android.content.pm.LauncherApps");
            sServiceMap.put("LAYOUT_INFLATER_SERVICE", "android.view.LayoutInflater");
            sServiceMap.put("LOCATION_SERVICE", "android.location.LocationManager");
            sServiceMap.put("MEDIA_PROJECTION_SERVICE", "android.media.projection.MediaProjectionManager");
            sServiceMap.put("MEDIA_ROUTER_SERVICE", "android.media.MediaRouter");
            sServiceMap.put("MEDIA_SESSION_SERVICE", "android.media.session.MediaSessionManager");
            sServiceMap.put("MIDI_SERVICE", "android.media.midi.MidiManager");
            sServiceMap.put("NETWORK_STATS_SERVICE", "android.app.usage.NetworkStatsManager");
            sServiceMap.put("NFC_SERVICE", "android.nfc.NfcManager");
            sServiceMap.put("NOTIFICATION_SERVICE", "android.app.NotificationManager");
            sServiceMap.put("NSD_SERVICE", "android.net.nsd.NsdManager");
            sServiceMap.put("POWER_SERVICE", "android.os.PowerManager");
            sServiceMap.put("PRINT_SERVICE", "android.print.PrintManager");
            sServiceMap.put("RESTRICTIONS_SERVICE", "android.content.RestrictionsManager");
            sServiceMap.put("SEARCH_SERVICE", "android.app.SearchManager");
            sServiceMap.put("SENSOR_SERVICE", "android.hardware.SensorManager");
            sServiceMap.put("STORAGE_SERVICE", "android.os.storage.StorageManager");
            sServiceMap.put("TELECOM_SERVICE", "android.telecom.TelecomManager");
            sServiceMap.put("TELEPHONY_SERVICE", "android.telephony.TelephonyManager");
            sServiceMap.put("TELEPHONY_SUBSCRIPTION_SERVICE", "android.telephony.SubscriptionManager");
            sServiceMap.put("TEXT_SERVICES_MANAGER_SERVICE", "android.view.textservice.TextServicesManager");
            sServiceMap.put("TV_INPUT_SERVICE", "android.media.tv.TvInputManager");
            sServiceMap.put("UI_MODE_SERVICE", "android.app.UiModeManager");
            sServiceMap.put("USAGE_STATS_SERVICE", "android.app.usage.UsageStatsManager");
            sServiceMap.put("USB_SERVICE", "android.hardware.usb.UsbManager");
            sServiceMap.put("USER_SERVICE", "android.os.UserManager");
            sServiceMap.put("VIBRATOR_SERVICE", "android.os.Vibrator");
            sServiceMap.put("WALLPAPER_SERVICE", "com.android.server.WallpaperService");
            sServiceMap.put("WIFI_P2P_SERVICE", "android.net.wifi.p2p.WifiP2pManager");
            sServiceMap.put("WIFI_SERVICE", "android.net.wifi.WifiManager");
            sServiceMap.put("WINDOW_SERVICE", "android.view.WindowManager");
            assert (sServiceMap.size() == 55) : sServiceMap.size();
        }
        return sServiceMap;
    }
}

