/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.MessageReflection;
import com.google.protobuf.TextFormatEscaper;
import com.google.protobuf.TextFormatParseInfoTree;
import com.google.protobuf.TextFormatParseLocation;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextFormat {
    private static final Logger logger = Logger.getLogger(TextFormat.class.getName());
    private static final Parser PARSER = Parser.newBuilder().build();

    private TextFormat() {
    }

    public static void print(MessageOrBuilder messageOrBuilder, Appendable appendable) throws IOException {
        Printer.DEFAULT.print(messageOrBuilder, TextFormat.multiLineOutput(appendable));
    }

    public static void print(UnknownFieldSet unknownFieldSet, Appendable appendable) throws IOException {
        Printer.DEFAULT.printUnknownFields(unknownFieldSet, TextFormat.multiLineOutput(appendable));
    }

    public static void printUnicode(MessageOrBuilder messageOrBuilder, Appendable appendable) throws IOException {
        Printer.UNICODE.print(messageOrBuilder, TextFormat.multiLineOutput(appendable));
    }

    public static void printUnicode(UnknownFieldSet unknownFieldSet, Appendable appendable) throws IOException {
        Printer.UNICODE.printUnknownFields(unknownFieldSet, TextFormat.multiLineOutput(appendable));
    }

    public static String shortDebugString(MessageOrBuilder messageOrBuilder) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Printer.DEFAULT.print(messageOrBuilder, TextFormat.singleLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String shortDebugString(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Printer.DEFAULT.printField(fieldDescriptor, object, TextFormat.singleLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String shortDebugString(UnknownFieldSet unknownFieldSet) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Printer.DEFAULT.printUnknownFields(unknownFieldSet, TextFormat.singleLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToString(MessageOrBuilder messageOrBuilder) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.print(messageOrBuilder, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToString(UnknownFieldSet unknownFieldSet) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.print(unknownFieldSet, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToUnicodeString(MessageOrBuilder messageOrBuilder) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Printer.UNICODE.print(messageOrBuilder, TextFormat.multiLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToUnicodeString(UnknownFieldSet unknownFieldSet) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Printer.UNICODE.printUnknownFields(unknownFieldSet, TextFormat.multiLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static void printField(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
        Printer.DEFAULT.printField(fieldDescriptor, object, TextFormat.multiLineOutput(appendable));
    }

    public static String printFieldToString(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.printField(fieldDescriptor, object, stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static void printUnicodeFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
        Printer.UNICODE.printFieldValue(fieldDescriptor, object, TextFormat.multiLineOutput(appendable));
    }

    public static void printFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
        Printer.DEFAULT.printFieldValue(fieldDescriptor, object, TextFormat.multiLineOutput(appendable));
    }

    public static void printUnknownFieldValue(int n, Object object, Appendable appendable) throws IOException {
        TextFormat.printUnknownFieldValue(n, object, TextFormat.multiLineOutput(appendable));
    }

    private static void printUnknownFieldValue(int n, Object object, TextGenerator textGenerator) throws IOException {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                textGenerator.print(TextFormat.unsignedToString((Long)object));
                break;
            }
            case 5: {
                textGenerator.print(String.format((Locale)null, "0x%08x", (Integer)object));
                break;
            }
            case 1: {
                textGenerator.print(String.format((Locale)null, "0x%016x", (Long)object));
                break;
            }
            case 2: {
                textGenerator.print("\"");
                textGenerator.print(TextFormat.escapeBytes((ByteString)object));
                textGenerator.print("\"");
                break;
            }
            case 3: {
                Printer.DEFAULT.printUnknownFields((UnknownFieldSet)object, textGenerator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad tag: " + n);
            }
        }
    }

    public static String unsignedToString(int n) {
        if (n >= 0) {
            return Integer.toString(n);
        }
        return Long.toString((long)n & 0xFFFFFFFFL);
    }

    public static String unsignedToString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        return BigInteger.valueOf(l & Long.MAX_VALUE).setBit(63).toString();
    }

    private static TextGenerator multiLineOutput(Appendable appendable) {
        return new TextGenerator(appendable, false);
    }

    private static TextGenerator singleLineOutput(Appendable appendable) {
        return new TextGenerator(appendable, true);
    }

    public static Parser getParser() {
        return PARSER;
    }

    public static void merge(Readable readable, Message.Builder builder) throws IOException {
        PARSER.merge(readable, builder);
    }

    public static void merge(CharSequence charSequence, Message.Builder builder) throws ParseException {
        PARSER.merge(charSequence, builder);
    }

    public static void merge(Readable readable, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        PARSER.merge(readable, extensionRegistry, builder);
    }

    public static void merge(CharSequence charSequence, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        PARSER.merge(charSequence, extensionRegistry, builder);
    }

    public static String escapeBytes(ByteString byteString) {
        return TextFormatEscaper.escapeBytes(byteString);
    }

    public static String escapeBytes(byte[] byArray) {
        return TextFormatEscaper.escapeBytes(byArray);
    }

    public static ByteString unescapeBytes(CharSequence charSequence) throws InvalidEscapeSequenceException {
        ByteString byteString = ByteString.copyFromUtf8(charSequence.toString());
        byte[] byArray = new byte[byteString.size()];
        int n = 0;
        block13: for (int i = 0; i < byteString.size(); ++i) {
            byte by = byteString.byteAt(i);
            if (by == 92) {
                if (i + 1 < byteString.size()) {
                    int n2;
                    if (TextFormat.isOctal(by = byteString.byteAt(++i))) {
                        n2 = TextFormat.digitValue(by);
                        if (i + 1 < byteString.size() && TextFormat.isOctal(byteString.byteAt(i + 1))) {
                            n2 = n2 * 8 + TextFormat.digitValue(byteString.byteAt(++i));
                        }
                        if (i + 1 < byteString.size() && TextFormat.isOctal(byteString.byteAt(i + 1))) {
                            n2 = n2 * 8 + TextFormat.digitValue(byteString.byteAt(++i));
                        }
                        byArray[n++] = (byte)n2;
                        continue;
                    }
                    switch (by) {
                        case 97: {
                            byArray[n++] = 7;
                            continue block13;
                        }
                        case 98: {
                            byArray[n++] = 8;
                            continue block13;
                        }
                        case 102: {
                            byArray[n++] = 12;
                            continue block13;
                        }
                        case 110: {
                            byArray[n++] = 10;
                            continue block13;
                        }
                        case 114: {
                            byArray[n++] = 13;
                            continue block13;
                        }
                        case 116: {
                            byArray[n++] = 9;
                            continue block13;
                        }
                        case 118: {
                            byArray[n++] = 11;
                            continue block13;
                        }
                        case 92: {
                            byArray[n++] = 92;
                            continue block13;
                        }
                        case 39: {
                            byArray[n++] = 39;
                            continue block13;
                        }
                        case 34: {
                            byArray[n++] = 34;
                            continue block13;
                        }
                        case 120: {
                            n2 = 0;
                            if (i + 1 >= byteString.size() || !TextFormat.isHex(byteString.byteAt(i + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            n2 = TextFormat.digitValue(byteString.byteAt(++i));
                            if (i + 1 < byteString.size() && TextFormat.isHex(byteString.byteAt(i + 1))) {
                                n2 = n2 * 16 + TextFormat.digitValue(byteString.byteAt(++i));
                            }
                            byArray[n++] = (byte)n2;
                            continue block13;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + (char)by + '\'');
                        }
                    }
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            byArray[n++] = by;
        }
        return byArray.length == n ? ByteString.wrap(byArray) : ByteString.copyFrom(byArray, 0, n);
    }

    static String escapeText(String string) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(string));
    }

    public static String escapeDoubleQuotesAndBackslashes(String string) {
        return TextFormatEscaper.escapeDoubleQuotesAndBackslashes(string);
    }

    static String unescapeText(String string) throws InvalidEscapeSequenceException {
        return TextFormat.unescapeBytes(string).toStringUtf8();
    }

    private static boolean isOctal(byte by) {
        return 48 <= by && by <= 55;
    }

    private static boolean isHex(byte by) {
        return 48 <= by && by <= 57 || 97 <= by && by <= 102 || 65 <= by && by <= 70;
    }

    private static int digitValue(byte by) {
        if (48 <= by && by <= 57) {
            return by - 48;
        }
        if (97 <= by && by <= 122) {
            return by - 97 + 10;
        }
        return by - 65 + 10;
    }

    static int parseInt32(String string) throws NumberFormatException {
        return (int)TextFormat.parseInteger(string, true, false);
    }

    static int parseUInt32(String string) throws NumberFormatException {
        return (int)TextFormat.parseInteger(string, false, false);
    }

    static long parseInt64(String string) throws NumberFormatException {
        return TextFormat.parseInteger(string, true, true);
    }

    static long parseUInt64(String string) throws NumberFormatException {
        return TextFormat.parseInteger(string, false, true);
    }

    private static long parseInteger(String string, boolean bl, boolean bl2) throws NumberFormatException {
        int n = 0;
        boolean bl3 = false;
        if (string.startsWith("-", n)) {
            if (!bl) {
                throw new NumberFormatException("Number must be positive: " + string);
            }
            ++n;
            bl3 = true;
        }
        int n2 = 10;
        if (string.startsWith("0x", n)) {
            n += 2;
            n2 = 16;
        } else if (string.startsWith("0", n)) {
            n2 = 8;
        }
        String string2 = string.substring(n);
        long l = 0L;
        if (string2.length() < 16) {
            l = Long.parseLong(string2, n2);
            if (bl3) {
                l = -l;
            }
            if (!bl2) {
                if (bl) {
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + string);
                    }
                } else if (l >= 0x100000000L || l < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + string);
                }
            }
        } else {
            BigInteger bigInteger = new BigInteger(string2, n2);
            if (bl3) {
                bigInteger = bigInteger.negate();
            }
            if (!bl2) {
                if (bl) {
                    if (bigInteger.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + string);
                    }
                } else if (bigInteger.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + string);
                }
            } else if (bl) {
                if (bigInteger.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + string);
                }
            } else if (bigInteger.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + string);
            }
            l = bigInteger.longValue();
        }
        return l;
    }

    public static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String string) {
            super(string);
        }
    }

    public static class Parser {
        private final boolean allowUnknownFields;
        private final SingularOverwritePolicy singularOverwritePolicy;
        private TextFormatParseInfoTree.Builder parseInfoTreeBuilder;
        private static final int BUFFER_SIZE = 4096;

        private Parser(boolean bl, SingularOverwritePolicy singularOverwritePolicy, TextFormatParseInfoTree.Builder builder) {
            this.allowUnknownFields = bl;
            this.singularOverwritePolicy = singularOverwritePolicy;
            this.parseInfoTreeBuilder = builder;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public void merge(Readable readable, Message.Builder builder) throws IOException {
            this.merge(readable, ExtensionRegistry.getEmptyRegistry(), builder);
        }

        public void merge(CharSequence charSequence, Message.Builder builder) throws ParseException {
            this.merge(charSequence, ExtensionRegistry.getEmptyRegistry(), builder);
        }

        public void merge(Readable readable, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
            this.merge(Parser.toStringBuilder(readable), extensionRegistry, builder);
        }

        private static StringBuilder toStringBuilder(Readable readable) throws IOException {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            CharBuffer charBuffer = CharBuffer.allocate(4096);
            while ((n = readable.read(charBuffer)) != -1) {
                charBuffer.flip();
                stringBuilder.append(charBuffer, 0, n);
            }
            return stringBuilder;
        }

        private void checkUnknownFields(List<String> list) throws ParseException {
            if (list.isEmpty()) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder("Input contains unknown fields and/or extensions:");
            for (String string : list) {
                stringBuilder.append('\n').append(string);
            }
            if (!this.allowUnknownFields) {
                String[] stringArray = list.get(0).split(":");
                throw new ParseException(Integer.valueOf(stringArray[0]), Integer.valueOf(stringArray[1]), stringBuilder.toString());
            }
            logger.warning(stringBuilder.toString());
        }

        public void merge(CharSequence charSequence, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
            Tokenizer tokenizer = new Tokenizer(charSequence);
            MessageReflection.BuilderAdapter builderAdapter = new MessageReflection.BuilderAdapter(builder);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!tokenizer.atEnd()) {
                this.mergeField(tokenizer, extensionRegistry, builderAdapter, arrayList);
            }
            this.checkUnknownFields(arrayList);
        }

        private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget mergeTarget, List<String> list) throws ParseException {
            this.mergeField(tokenizer, extensionRegistry, mergeTarget, this.parseInfoTreeBuilder, list);
        }

        private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget mergeTarget, TextFormatParseInfoTree.Builder builder, List<String> list) throws ParseException {
            Object object;
            Descriptors.FieldDescriptor fieldDescriptor = null;
            int n = tokenizer.getLine();
            int n2 = tokenizer.getColumn();
            Descriptors.Descriptor descriptor = mergeTarget.getDescriptorForType();
            ExtensionRegistry.ExtensionInfo extensionInfo = null;
            if (tokenizer.tryConsume("[")) {
                object = new StringBuilder(tokenizer.consumeIdentifier());
                while (tokenizer.tryConsume(".")) {
                    ((StringBuilder)object).append('.');
                    ((StringBuilder)object).append(tokenizer.consumeIdentifier());
                }
                extensionInfo = mergeTarget.findExtensionByName(extensionRegistry, ((StringBuilder)object).toString());
                if (extensionInfo == null) {
                    list.add(tokenizer.getPreviousLine() + 1 + ":" + (tokenizer.getPreviousColumn() + 1) + ":\t" + descriptor.getFullName() + ".[" + object + "]");
                } else {
                    if (extensionInfo.descriptor.getContainingType() != descriptor) {
                        throw tokenizer.parseExceptionPreviousToken("Extension \"" + object + "\" does not extend message type \"" + descriptor.getFullName() + "\".");
                    }
                    fieldDescriptor = extensionInfo.descriptor;
                }
                tokenizer.consume("]");
            } else {
                String string;
                object = tokenizer.consumeIdentifier();
                fieldDescriptor = descriptor.findFieldByName((String)object);
                if (fieldDescriptor == null && (fieldDescriptor = descriptor.findFieldByName(string = ((String)object).toLowerCase(Locale.US))) != null && fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                    fieldDescriptor = null;
                }
                if (fieldDescriptor != null && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP && !fieldDescriptor.getMessageType().getName().equals(object)) {
                    fieldDescriptor = null;
                }
                if (fieldDescriptor == null) {
                    list.add(tokenizer.getPreviousLine() + 1 + ":" + (tokenizer.getPreviousColumn() + 1) + ":\t" + descriptor.getFullName() + "." + (String)object);
                }
            }
            if (fieldDescriptor == null) {
                if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("{") && !tokenizer.lookingAt("<")) {
                    this.skipFieldValue(tokenizer);
                } else {
                    this.skipFieldMessage(tokenizer);
                }
                return;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                tokenizer.tryConsume(":");
                if (builder != null) {
                    object = builder.getBuilderForSubMessageField(fieldDescriptor);
                    this.consumeFieldValues(tokenizer, extensionRegistry, mergeTarget, fieldDescriptor, extensionInfo, (TextFormatParseInfoTree.Builder)object, list);
                } else {
                    this.consumeFieldValues(tokenizer, extensionRegistry, mergeTarget, fieldDescriptor, extensionInfo, builder, list);
                }
            } else {
                tokenizer.consume(":");
                this.consumeFieldValues(tokenizer, extensionRegistry, mergeTarget, fieldDescriptor, extensionInfo, builder, list);
            }
            if (builder != null) {
                builder.setLocation(fieldDescriptor, TextFormatParseLocation.create(n, n2));
            }
            if (!tokenizer.tryConsume(";")) {
                tokenizer.tryConsume(",");
            }
        }

        private void consumeFieldValues(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget mergeTarget, Descriptors.FieldDescriptor fieldDescriptor, ExtensionRegistry.ExtensionInfo extensionInfo, TextFormatParseInfoTree.Builder builder, List<String> list) throws ParseException {
            if (fieldDescriptor.isRepeated() && tokenizer.tryConsume("[")) {
                if (!tokenizer.tryConsume("]")) {
                    while (true) {
                        this.consumeFieldValue(tokenizer, extensionRegistry, mergeTarget, fieldDescriptor, extensionInfo, builder, list);
                        if (!tokenizer.tryConsume("]")) {
                            tokenizer.consume(",");
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.consumeFieldValue(tokenizer, extensionRegistry, mergeTarget, fieldDescriptor, extensionInfo, builder, list);
            }
        }

        private void consumeFieldValue(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget mergeTarget, Descriptors.FieldDescriptor fieldDescriptor, ExtensionRegistry.ExtensionInfo extensionInfo, TextFormatParseInfoTree.Builder builder, List<String> list) throws ParseException {
            Object object;
            Object object2 = null;
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (tokenizer.tryConsume("<")) {
                    object = ">";
                } else {
                    tokenizer.consume("{");
                    object = "}";
                }
                MessageReflection.MergeTarget mergeTarget2 = mergeTarget.newMergeTargetForField(fieldDescriptor, extensionInfo == null ? null : extensionInfo.defaultInstance);
                while (!tokenizer.tryConsume((String)object)) {
                    if (tokenizer.atEnd()) {
                        throw tokenizer.parseException("Expected \"" + (String)object + "\".");
                    }
                    this.mergeField(tokenizer, extensionRegistry, mergeTarget2, builder, list);
                }
                object2 = mergeTarget2.finish();
            } else {
                switch (fieldDescriptor.getType()) {
                    case INT32: 
                    case SINT32: 
                    case SFIXED32: {
                        object2 = tokenizer.consumeInt32();
                        break;
                    }
                    case INT64: 
                    case SINT64: 
                    case SFIXED64: {
                        object2 = tokenizer.consumeInt64();
                        break;
                    }
                    case UINT32: 
                    case FIXED32: {
                        object2 = tokenizer.consumeUInt32();
                        break;
                    }
                    case UINT64: 
                    case FIXED64: {
                        object2 = tokenizer.consumeUInt64();
                        break;
                    }
                    case FLOAT: {
                        object2 = Float.valueOf(tokenizer.consumeFloat());
                        break;
                    }
                    case DOUBLE: {
                        object2 = tokenizer.consumeDouble();
                        break;
                    }
                    case BOOL: {
                        object2 = tokenizer.consumeBoolean();
                        break;
                    }
                    case STRING: {
                        object2 = tokenizer.consumeString();
                        break;
                    }
                    case BYTES: {
                        object2 = tokenizer.consumeByteString();
                        break;
                    }
                    case ENUM: {
                        object = fieldDescriptor.getEnumType();
                        if (tokenizer.lookingAtInteger()) {
                            int n = tokenizer.consumeInt32();
                            object2 = ((Descriptors.EnumDescriptor)object).findValueByNumber(n);
                            if (object2 != null) break;
                            throw tokenizer.parseExceptionPreviousToken("Enum type \"" + ((Descriptors.EnumDescriptor)object).getFullName() + "\" has no value with number " + n + '.');
                        }
                        String string = tokenizer.consumeIdentifier();
                        object2 = ((Descriptors.EnumDescriptor)object).findValueByName(string);
                        if (object2 != null) break;
                        throw tokenizer.parseExceptionPreviousToken("Enum type \"" + ((Descriptors.EnumDescriptor)object).getFullName() + "\" has no value named \"" + string + "\".");
                    }
                    case MESSAGE: 
                    case GROUP: {
                        throw new RuntimeException("Can't get here.");
                    }
                }
            }
            if (fieldDescriptor.isRepeated()) {
                mergeTarget.addRepeatedField(fieldDescriptor, object2);
            } else {
                if (this.singularOverwritePolicy == SingularOverwritePolicy.FORBID_SINGULAR_OVERWRITES && mergeTarget.hasField(fieldDescriptor)) {
                    throw tokenizer.parseExceptionPreviousToken("Non-repeated field \"" + fieldDescriptor.getFullName() + "\" cannot be overwritten.");
                }
                if (this.singularOverwritePolicy == SingularOverwritePolicy.FORBID_SINGULAR_OVERWRITES && fieldDescriptor.getContainingOneof() != null && mergeTarget.hasOneof(fieldDescriptor.getContainingOneof())) {
                    object = fieldDescriptor.getContainingOneof();
                    throw tokenizer.parseExceptionPreviousToken("Field \"" + fieldDescriptor.getFullName() + "\" is specified along with field \"" + mergeTarget.getOneofFieldDescriptor((Descriptors.OneofDescriptor)object).getFullName() + "\", another member of oneof \"" + ((Descriptors.OneofDescriptor)object).getName() + "\".");
                }
                mergeTarget.setField(fieldDescriptor, object2);
            }
        }

        private void skipField(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsume("[")) {
                do {
                    tokenizer.consumeIdentifier();
                } while (tokenizer.tryConsume("."));
                tokenizer.consume("]");
            } else {
                tokenizer.consumeIdentifier();
            }
            if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("<") && !tokenizer.lookingAt("{")) {
                this.skipFieldValue(tokenizer);
            } else {
                this.skipFieldMessage(tokenizer);
            }
            if (!tokenizer.tryConsume(";")) {
                tokenizer.tryConsume(",");
            }
        }

        private void skipFieldMessage(Tokenizer tokenizer) throws ParseException {
            String string;
            if (tokenizer.tryConsume("<")) {
                string = ">";
            } else {
                tokenizer.consume("{");
                string = "}";
            }
            while (!tokenizer.lookingAt(">") && !tokenizer.lookingAt("}")) {
                this.skipField(tokenizer);
            }
            tokenizer.consume(string);
        }

        private void skipFieldValue(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsumeString()) {
                while (tokenizer.tryConsumeString()) {
                }
                return;
            }
            if (!(tokenizer.tryConsumeIdentifier() || tokenizer.tryConsumeInt64() || tokenizer.tryConsumeUInt64() || tokenizer.tryConsumeDouble() || tokenizer.tryConsumeFloat())) {
                throw tokenizer.parseException("Invalid field value: " + tokenizer.currentToken);
            }
        }

        public static class Builder {
            private boolean allowUnknownFields = false;
            private SingularOverwritePolicy singularOverwritePolicy = SingularOverwritePolicy.ALLOW_SINGULAR_OVERWRITES;
            private TextFormatParseInfoTree.Builder parseInfoTreeBuilder = null;

            public Builder setSingularOverwritePolicy(SingularOverwritePolicy singularOverwritePolicy) {
                this.singularOverwritePolicy = singularOverwritePolicy;
                return this;
            }

            public Builder setParseInfoTreeBuilder(TextFormatParseInfoTree.Builder builder) {
                this.parseInfoTreeBuilder = builder;
                return this;
            }

            public Parser build() {
                return new Parser(this.allowUnknownFields, this.singularOverwritePolicy, this.parseInfoTreeBuilder);
            }
        }

        public static enum SingularOverwritePolicy {
            ALLOW_SINGULAR_OVERWRITES,
            FORBID_SINGULAR_OVERWRITES;

        }
    }

    public static class UnknownFieldParseException
    extends ParseException {
        private final String unknownField;

        public UnknownFieldParseException(String string) {
            this(-1, -1, "", string);
        }

        public UnknownFieldParseException(int n, int n2, String string, String string2) {
            super(n, n2, string2);
            this.unknownField = string;
        }

        public String getUnknownField() {
            return this.unknownField;
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;
        private final int line;
        private final int column;

        public ParseException(String string) {
            this(-1, -1, string);
        }

        public ParseException(int n, int n2, String string) {
            super(Integer.toString(n) + ":" + n2 + ": " + string);
            this.line = n;
            this.column = n2;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence charSequence) {
            this.text = charSequence;
            this.matcher = WHITESPACE.matcher(charSequence);
            this.skipWhitespace();
            this.nextToken();
        }

        int getPreviousLine() {
            return this.previousLine;
        }

        int getPreviousColumn() {
            return this.previousColumn;
        }

        int getLine() {
            return this.line;
        }

        int getColumn() {
            return this.column;
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String string) {
            if (this.currentToken.equals(string)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String string) throws ParseException {
            if (!this.tryConsume(string)) {
                throw this.parseException("Expected \"" + string + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public boolean lookingAt(String string) {
            return this.currentToken.equals(string);
        }

        public String consumeIdentifier() throws ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c = this.currentToken.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.') continue;
                throw this.parseException("Expected identifier. Found '" + this.currentToken + "'");
            }
            String string = this.currentToken;
            this.nextToken();
            return string;
        }

        public boolean tryConsumeIdentifier() {
            try {
                this.consumeIdentifier();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public int consumeInt32() throws ParseException {
            try {
                int n = TextFormat.parseInt32(this.currentToken);
                this.nextToken();
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int n = TextFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long l = TextFormat.parseInt64(this.currentToken);
                this.nextToken();
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public boolean tryConsumeInt64() {
            try {
                this.consumeInt64();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long l = TextFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public boolean tryConsumeUInt64() {
            try {
                this.consumeUInt64();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean bl = this.currentToken.startsWith("-");
                this.nextToken();
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double d = Double.parseDouble(this.currentToken);
                this.nextToken();
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.floatParseException(numberFormatException);
            }
        }

        public boolean tryConsumeDouble() {
            try {
                this.consumeDouble();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean bl = this.currentToken.startsWith("-");
                this.nextToken();
                return bl ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float f = Float.parseFloat(this.currentToken);
                this.nextToken();
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.floatParseException(numberFormatException);
            }
        }

        public boolean tryConsumeFloat() {
            try {
                this.consumeFloat();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true") || this.currentToken.equals("True") || this.currentToken.equals("t") || this.currentToken.equals("1")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false") || this.currentToken.equals("False") || this.currentToken.equals("f") || this.currentToken.equals("0")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public boolean tryConsumeString() {
            try {
                this.consumeString();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public ByteString consumeByteString() throws ParseException {
            ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
            this.consumeByteString(arrayList);
            while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
                this.consumeByteString(arrayList);
            }
            return ByteString.copyFrom(arrayList);
        }

        private void consumeByteString(List<ByteString> list) throws ParseException {
            char c;
            char c2 = c = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (c != '\"' && c != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != c) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String string = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString byteString = TextFormat.unescapeBytes(string);
                this.nextToken();
                list.add(byteString);
            }
            catch (InvalidEscapeSequenceException invalidEscapeSequenceException) {
                throw this.parseException(invalidEscapeSequenceException.getMessage());
            }
        }

        public ParseException parseException(String string) {
            return new ParseException(this.line + 1, this.column + 1, string);
        }

        public ParseException parseExceptionPreviousToken(String string) {
            return new ParseException(this.previousLine + 1, this.previousColumn + 1, string);
        }

        private ParseException integerParseException(NumberFormatException numberFormatException) {
            return this.parseException("Couldn't parse integer: " + numberFormatException.getMessage());
        }

        private ParseException floatParseException(NumberFormatException numberFormatException) {
            return this.parseException("Couldn't parse number: " + numberFormatException.getMessage());
        }

        public UnknownFieldParseException unknownFieldParseExceptionPreviousToken(String string, String string2) {
            return new UnknownFieldParseException(this.previousLine + 1, this.previousColumn + 1, string, string2);
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private final boolean singleLineMode;
        private boolean atStartOfLine = false;

        private TextGenerator(Appendable appendable, boolean bl) {
            this.output = appendable;
            this.singleLineMode = bl;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int n = this.indent.length();
            if (n == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.setLength(n - 2);
        }

        public void print(CharSequence charSequence) throws IOException {
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.singleLineMode ? " " : this.indent);
            }
            this.output.append(charSequence);
        }

        public void eol() throws IOException {
            if (!this.singleLineMode) {
                this.output.append("\n");
            }
            this.atStartOfLine = true;
        }
    }

    private static final class Printer {
        static final Printer DEFAULT = new Printer(true);
        static final Printer UNICODE = new Printer(false);
        private final boolean escapeNonAscii;

        private Printer(boolean bl) {
            this.escapeNonAscii = bl;
        }

        private void print(MessageOrBuilder messageOrBuilder, TextGenerator textGenerator) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : messageOrBuilder.getAllFields().entrySet()) {
                this.printField(entry.getKey(), entry.getValue(), textGenerator);
            }
            this.printUnknownFields(messageOrBuilder.getUnknownFields(), textGenerator);
        }

        private void printField(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
            if (fieldDescriptor.isRepeated()) {
                for (Object e : (List)object) {
                    this.printSingleField(fieldDescriptor, e, textGenerator);
                }
            } else {
                this.printSingleField(fieldDescriptor, object, textGenerator);
            }
        }

        private void printSingleField(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
            if (fieldDescriptor.isExtension()) {
                textGenerator.print("[");
                if (fieldDescriptor.getContainingType().getOptions().getMessageSetWireFormat() && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && fieldDescriptor.isOptional() && fieldDescriptor.getExtensionScope() == fieldDescriptor.getMessageType()) {
                    textGenerator.print(fieldDescriptor.getMessageType().getFullName());
                } else {
                    textGenerator.print(fieldDescriptor.getFullName());
                }
                textGenerator.print("]");
            } else if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                textGenerator.print(fieldDescriptor.getMessageType().getName());
            } else {
                textGenerator.print(fieldDescriptor.getName());
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                textGenerator.print(" {");
                textGenerator.eol();
                textGenerator.indent();
            } else {
                textGenerator.print(": ");
            }
            this.printFieldValue(fieldDescriptor, object, textGenerator);
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                textGenerator.outdent();
                textGenerator.print("}");
            }
            textGenerator.eol();
        }

        private void printFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
            switch (fieldDescriptor.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    textGenerator.print(((Integer)object).toString());
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    textGenerator.print(((Long)object).toString());
                    break;
                }
                case BOOL: {
                    textGenerator.print(((Boolean)object).toString());
                    break;
                }
                case FLOAT: {
                    textGenerator.print(((Float)object).toString());
                    break;
                }
                case DOUBLE: {
                    textGenerator.print(((Double)object).toString());
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    textGenerator.print(TextFormat.unsignedToString((Integer)object));
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    textGenerator.print(TextFormat.unsignedToString((Long)object));
                    break;
                }
                case STRING: {
                    textGenerator.print("\"");
                    textGenerator.print(this.escapeNonAscii ? TextFormatEscaper.escapeText((String)object) : TextFormat.escapeDoubleQuotesAndBackslashes((String)object).replace("\n", "\\n"));
                    textGenerator.print("\"");
                    break;
                }
                case BYTES: {
                    textGenerator.print("\"");
                    if (object instanceof ByteString) {
                        textGenerator.print(TextFormat.escapeBytes((ByteString)object));
                    } else {
                        textGenerator.print(TextFormat.escapeBytes((byte[])object));
                    }
                    textGenerator.print("\"");
                    break;
                }
                case ENUM: {
                    textGenerator.print(((Descriptors.EnumValueDescriptor)object).getName());
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((Message)object, textGenerator);
                }
            }
        }

        private void printUnknownFields(UnknownFieldSet unknownFieldSet, TextGenerator textGenerator) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFieldSet.asMap().entrySet()) {
                int n = entry.getKey();
                UnknownFieldSet.Field field = entry.getValue();
                this.printUnknownField(n, 0, field.getVarintList(), textGenerator);
                this.printUnknownField(n, 5, field.getFixed32List(), textGenerator);
                this.printUnknownField(n, 1, field.getFixed64List(), textGenerator);
                this.printUnknownField(n, 2, field.getLengthDelimitedList(), textGenerator);
                for (UnknownFieldSet unknownFieldSet2 : field.getGroupList()) {
                    textGenerator.print(entry.getKey().toString());
                    textGenerator.print(" {");
                    textGenerator.eol();
                    textGenerator.indent();
                    this.printUnknownFields(unknownFieldSet2, textGenerator);
                    textGenerator.outdent();
                    textGenerator.print("}");
                    textGenerator.eol();
                }
            }
        }

        private void printUnknownField(int n, int n2, List<?> list, TextGenerator textGenerator) throws IOException {
            for (Object obj : list) {
                textGenerator.print(String.valueOf(n));
                textGenerator.print(": ");
                TextFormat.printUnknownFieldValue(n2, obj, textGenerator);
                textGenerator.eol();
            }
        }
    }
}

