/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="NullTernary", summary="This conditional expression may evaluate to null, which will result in an NPE when the result is unboxed.", severity=BugPattern.SeverityLevel.ERROR, category=BugPattern.Category.JDK)
public class NullTernary
extends BugChecker
implements BugChecker.ConditionalExpressionTreeMatcher {
    public Description matchConditionalExpression(final ConditionalExpressionTree conditionalExpression, final VisitorState state) {
        if (conditionalExpression.getFalseExpression().getKind() != Tree.Kind.NULL_LITERAL && conditionalExpression.getTrueExpression().getKind() != Tree.Kind.NULL_LITERAL) {
            return Description.NO_MATCH;
        }
        TreePath path = state.getPath();
        while ((path = path.getParentPath()) != null && path.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
        }
        if (path == null) {
            return Description.NO_MATCH;
        }
        Tree parent = path.getLeaf();
        Type type = parent.accept(new SimpleTreeVisitor<Type, Void>(){

            @Override
            public Type visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                int idx = tree.getArguments().indexOf(conditionalExpression);
                if (idx == -1) {
                    return null;
                }
                Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
                if (((List)sym.getParameters()).size() <= idx) {
                    Preconditions.checkState((boolean)sym.isVarArgs());
                    idx = ((List)sym.getParameters()).size() - 1;
                }
                TypeMirror type = ((Symbol.VarSymbol)((List)sym.getParameters()).get(idx)).asType();
                if (sym.isVarArgs() && idx == ((List)sym.getParameters()).size() - 1) {
                    type = state.getTypes().elemtype((Type)type);
                }
                return type;
            }

            @Override
            public Type visitVariable(VariableTree tree, Void unused) {
                return ASTHelpers.getType((Tree)tree);
            }

            @Override
            public Type visitBinary(BinaryTree tree, Void unused) {
                return ASTHelpers.getType((Tree)(ASTHelpers.stripParentheses((ExpressionTree)tree.getLeftOperand()).equals(conditionalExpression) ? tree.getRightOperand() : tree.getLeftOperand()));
            }
        }, null);
        if (type == null || !type.isPrimitive()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(conditionalExpression);
    }
}

