/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Types;

@BugPattern(name="NestedInstanceOfConditions", category=BugPattern.Category.JDK, summary="Nested instanceOf conditions of disjoint types create blocks of code that never execute", severity=BugPattern.SeverityLevel.WARNING)
public class NestedInstanceOfConditions
extends BugChecker
implements BugChecker.IfTreeMatcher {
    public Description matchIf(IfTree ifTree, VisitorState visitorState) {
        ParenthesizedTree parenTree = (ParenthesizedTree)ifTree.getCondition();
        if (parenTree.getExpression() instanceof InstanceOfTree) {
            InstanceOfTree instanceOfTree = (InstanceOfTree)parenTree.getExpression();
            if (!(instanceOfTree.getExpression() instanceof IdentifierTree)) {
                return Description.NO_MATCH;
            }
            AssignmentTreeMatcher assignmentTreeMatcher = new AssignmentTreeMatcher(instanceOfTree.getExpression());
            Matcher containsAssignmentTreeMatcher = Matchers.contains((Matcher)assignmentTreeMatcher);
            if (containsAssignmentTreeMatcher.matches((Tree)ifTree, visitorState)) {
                return Description.NO_MATCH;
            }
            NestedInstanceOfMatcher nestedInstanceOfMatcher = new NestedInstanceOfMatcher(instanceOfTree.getExpression(), instanceOfTree.getType());
            Matcher containsNestedInstanceOfMatcher = Matchers.contains((Matcher)nestedInstanceOfMatcher);
            if (containsNestedInstanceOfMatcher.matches((Tree)ifTree.getThenStatement(), visitorState)) {
                return this.describeMatch(ifTree);
            }
        }
        return Description.NO_MATCH;
    }

    private static class NestedInstanceOfMatcher
    implements Matcher<Tree> {
        private final ExpressionTree expressionTree;
        private final Tree typeTree;

        public NestedInstanceOfMatcher(ExpressionTree e, Tree t) {
            this.expressionTree = e;
            this.typeTree = t;
        }

        public boolean matches(Tree tree, VisitorState state) {
            ParenthesizedTree parenTree;
            if (tree instanceof IfTree && (parenTree = (ParenthesizedTree)((IfTree)tree).getCondition()).getExpression() instanceof InstanceOfTree) {
                InstanceOfTree instanceTree = (InstanceOfTree)parenTree.getExpression();
                Types types = state.getTypes();
                boolean isCastable = types.isCastable(types.erasure(ASTHelpers.getType((Tree)instanceTree.getType())), types.erasure(ASTHelpers.getType((Tree)this.typeTree)));
                boolean isSameExpression = ((InstanceOfTree)parenTree.getExpression()).getExpression().toString().equals(this.expressionTree.toString());
                return isSameExpression && !isCastable;
            }
            return false;
        }
    }

    private static class AssignmentTreeMatcher
    implements Matcher<Tree> {
        private final ExpressionTree variableExpressionTree;

        public AssignmentTreeMatcher(ExpressionTree e) {
            this.variableExpressionTree = e;
        }

        public boolean matches(Tree tree, VisitorState visitorState) {
            if (tree instanceof AssignmentTree) {
                return this.variableExpressionTree.toString().equals(((AssignmentTree)tree).getVariable().toString());
            }
            return false;
        }
    }
}

