/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="ComplexBooleanConstant", summary="Non-trivial compile time constant boolean expressions shouldn't be used.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class ComplexBooleanConstant
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!(tree.getLeftOperand() instanceof JCTree.JCLiteral)) {
            return Description.NO_MATCH;
        }
        if (!(tree.getRightOperand() instanceof JCTree.JCLiteral)) {
            return Description.NO_MATCH;
        }
        Boolean constValue = (Boolean)ASTHelpers.constValue((Tree)tree, Boolean.class);
        if (constValue == null) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix((Fix)SuggestedFix.replace((Tree)tree, (String)constValue.toString())).setMessage(String.format("This expression always evalutes to `%s`, prefer a boolean literal for clarity.", constValue)).build();
    }
}

