/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceItem;
import com.google.common.base.Objects;
import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResourceFile
extends DataFile<ResourceItem> {
    static final String ATTR_QUALIFIER = "qualifiers";
    private String mQualifiers;

    public ResourceFile(File file, ResourceItem item, String qualifiers) {
        super(file, DataFile.FileType.SINGLE_FILE);
        this.mQualifiers = qualifiers;
        this.init(item);
    }

    public ResourceFile(File file, List<ResourceItem> items, String qualifiers) {
        this(file, items, qualifiers, DataFile.FileType.XML_VALUES);
    }

    private ResourceFile(File file, List<ResourceItem> items, String qualifiers, DataFile.FileType fileType) {
        super(file, fileType);
        this.mQualifiers = qualifiers;
        this.init(items);
    }

    public static ResourceFile generatedFiles(File file, List<ResourceItem> items, String qualifiers) {
        return new ResourceFile(file, items, qualifiers, DataFile.FileType.GENERATED_FILES);
    }

    public String getQualifiers() {
        return this.mQualifiers;
    }

    public void setQualifiers(String qualifiers) {
        this.mQualifiers = qualifiers;
    }

    @Override
    void addExtraAttributes(Document document, Node node, String namespaceUri) {
        NodeUtils.addAttribute(document, node, namespaceUri, ATTR_QUALIFIER, this.getQualifiers());
        if (this.getType() == DataFile.FileType.GENERATED_FILES) {
            NodeUtils.addAttribute(document, node, namespaceUri, "preprocessing", "true");
        }
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("mFile", (Object)this.mFile).add("mQualifiers", (Object)this.mQualifiers).toString();
    }
}

