/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import lombok.ast.Comment;
import lombok.ast.Identifier;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.grammar.BasicsParser;
import lombok.ast.grammar.Source;
import lombok.ast.grammar.SourceActions;
import org.parboiled.Context;

public class BasicsActions
extends SourceActions {
    public BasicsActions(Source source) {
        super(source);
    }

    public Node createIdentifier(String text, org.parboiled.Node<Node> rawIdentifier) {
        Identifier id = new Identifier();
        if (text != null) {
            id.astValue(text);
        }
        int start = rawIdentifier.getStartIndex();
        int end = Math.max(start, rawIdentifier.getEndIndex());
        id.setPosition(new Position(start, end));
        return id;
    }

    public boolean checkIfKeyword(String text) {
        return text == null || !BasicsParser.KEYWORDS.contains(text);
    }

    public boolean logComment(String text) {
        if (text.startsWith("//")) {
            return this.logLineComment(text);
        }
        return this.logBlockComment(text);
    }

    public boolean logBlockComment(String text) {
        if (text.startsWith("/*")) {
            text = text.substring(2);
        }
        if (text.endsWith("*/")) {
            text = text.substring(0, text.length() - 2);
        }
        Comment c = new Comment().astBlockComment(true).astContent(text);
        c.setPosition(new Position(this.startPos(), this.currentPos()));
        this.source.registerComment((Context<Node>)this.getContext(), c);
        return true;
    }

    public boolean logLineComment(String text) {
        if (text.startsWith("//")) {
            text = text.substring(2);
        }
        Comment c = new Comment().astBlockComment(false).astContent(text);
        c.setPosition(new Position(this.startPos(), this.currentPos()));
        this.source.registerComment((Context<Node>)this.getContext(), c);
        return true;
    }
}

