/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.main;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.turbine.binder.Binder;
import com.google.turbine.deps.Dependencies;
import com.google.turbine.deps.Transitive;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.lower.Lower;
import com.google.turbine.options.TurbineOptions;
import com.google.turbine.options.TurbineOptionsParser;
import com.google.turbine.parse.Parser;
import com.google.turbine.proto.DepsProto;
import com.google.turbine.tree.Tree;
import com.google.turbine.zip.Zip;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class Main {
    private static final int BUFFER_SIZE = 65536;

    public static void main(String[] args) throws IOException {
        Main.compile(args);
    }

    public static boolean compile(String[] args) throws IOException {
        TurbineOptions options = TurbineOptionsParser.parse(Arrays.asList(args));
        return Main.compile(options);
    }

    public static boolean compile(TurbineOptions options) throws IOException {
        if (!options.processors().isEmpty()) {
            return false;
        }
        ImmutableList<Tree.CompUnit> units = Main.parseAll(options);
        Collection<String> reducedClasspath = Dependencies.reduceClasspath(options.classPath(), options.directJarsToTargets(), options.depsArtifacts());
        Binder.BindingResult bound = Binder.bind(units, Main.toPaths(reducedClasspath), Main.toPaths(options.bootClassPath()));
        Lower.Lowered lowered = Lower.lowerAll(bound.units(), bound.classPathEnv());
        ImmutableMap<String, byte[]> transitive = Transitive.collectDeps(options.bootClassPath(), bound);
        if (options.outputDeps().isPresent()) {
            DepsProto.Dependencies deps = Dependencies.collectDeps(options.targetLabel(), options.bootClassPath(), bound, lowered);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get((String)options.outputDeps().get(), new String[0]), new OpenOption[0]));){
                deps.writeTo(os);
            }
        }
        Main.writeOutput(Paths.get(options.outputFile(), new String[0]), lowered.bytes(), transitive);
        return true;
    }

    private static ImmutableList<Tree.CompUnit> parseAll(TurbineOptions options) throws IOException {
        ImmutableList.Builder units = ImmutableList.builder();
        for (String source : options.sources()) {
            units.add((Object)Parser.parse(new SourceFile(source, new String(Files.readAllBytes(Paths.get(source, new String[0])), StandardCharsets.UTF_8))));
        }
        for (String sourceJar : options.sourceJars()) {
            for (Zip.Entry ze : new Zip.ZipIterable(Paths.get(sourceJar, new String[0]))) {
                if (!ze.name().endsWith(".java")) continue;
                String source = new String(ze.data(), StandardCharsets.UTF_8);
                units.add((Object)Parser.parse(new SourceFile(ze.name(), source)));
            }
        }
        return units.build();
    }

    private static void writeOutput(Path path, Map<String, byte[]> lowered, Map<String, byte[]> transitive) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os, 65536);
             JarOutputStream jos = new JarOutputStream(bos);){
            for (Map.Entry<String, byte[]> entry : lowered.entrySet()) {
                Main.addEntry(jos, entry.getKey() + ".class", entry.getValue());
            }
            for (Map.Entry<String, byte[]> entry : transitive.entrySet()) {
                Main.addEntry(jos, "META-INF/TRANSITIVE/" + entry.getKey() + ".class", entry.getValue());
            }
        }
    }

    private static void addEntry(JarOutputStream jos, String name, byte[] bytes) throws IOException {
        JarEntry je = new JarEntry(name);
        je.setTime(0L);
        je.setMethod(0);
        je.setSize(bytes.length);
        je.setCrc(Hashing.crc32().hashBytes(bytes).padToLong());
        jos.putNextEntry(je);
        jos.write(bytes);
    }

    private static ImmutableList<Path> toPaths(Iterable<String> paths) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String path : paths) {
            result.add((Object)Paths.get(path, new String[0]));
        }
        return result.build();
    }
}

