/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.spinning;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import java.io.IOException;
import java.util.logging.Level;

public abstract class AbstractHandler {
    protected final TcpIpConnectionManager connectionManager;
    protected final TcpIpConnection connection;
    protected final ILogger logger;
    protected final IOService ioService;

    public AbstractHandler(TcpIpConnection connection, ILogger logger) {
        this.connection = connection;
        this.connectionManager = connection.getConnectionManager();
        this.logger = logger;
        this.ioService = this.connectionManager.getIoService();
    }

    public void onFailure(Throwable e) {
        Level level;
        if (e instanceof OutOfMemoryError) {
            this.connectionManager.getIoService().onOutOfMemory((OutOfMemoryError)e);
        }
        this.connection.close(e);
        ConnectionType connectionType = this.connection.getType();
        if (connectionType.isClient() && !connectionType.isBinary()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().getName());
        sb.append(" Closing socket to endpoint ");
        sb.append(this.connection.getEndPoint());
        sb.append(", Cause:").append(e);
        Level level2 = level = this.connectionManager.getIoService().isActive() ? Level.WARNING : Level.FINEST;
        if (e instanceof IOException) {
            this.logger.log(level, sb.toString());
        } else {
            this.logger.log(level, sb.toString(), e);
        }
    }
}

