/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import com.hazelcast.util.QuickMath;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;

public class NearCacheRecord {
    private static final Comparator<NearCacheRecord> LRU_COMPARATOR = new Comparator<NearCacheRecord>(){

        @Override
        public int compare(NearCacheRecord o1, NearCacheRecord o2) {
            int result = QuickMath.compareLongs(o1.lastAccessTime, o2.lastAccessTime);
            if (result != 0) {
                return result;
            }
            return QuickMath.compareIntegers(o1.key.hashCode(), o2.key.hashCode());
        }
    };
    private static final Comparator<NearCacheRecord> LFU_COMPARATOR = new Comparator<NearCacheRecord>(){

        @Override
        public int compare(NearCacheRecord o1, NearCacheRecord o2) {
            int result = QuickMath.compareLongs(o1.hit.get(), o2.hit.get());
            if (result != 0) {
                return result;
            }
            return QuickMath.compareIntegers(o1.key.hashCode(), o2.key.hashCode());
        }
    };
    private static final Comparator<NearCacheRecord> DEFAULT_COMPARATOR = new Comparator<NearCacheRecord>(){

        @Override
        public int compare(NearCacheRecord o1, NearCacheRecord o2) {
            return QuickMath.compareIntegers(o1.key.hashCode(), o2.key.hashCode());
        }
    };
    private final Object key;
    private final Object value;
    private final long creationTime;
    private final AtomicLong hit;
    private volatile long lastAccessTime;

    public NearCacheRecord(Object key, Object value) {
        long time;
        assert (key != null);
        assert (value != null);
        this.key = key;
        this.value = value;
        this.lastAccessTime = time = Clock.currentTimeMillis();
        this.creationTime = time;
        this.hit = new AtomicLong();
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public void access() {
        this.hit.incrementAndGet();
        this.lastAccessTime = Clock.currentTimeMillis();
    }

    public long getCost() {
        if (!(this.value instanceof Data)) {
            return 0L;
        }
        if (!(this.key instanceof Data)) {
            return 0L;
        }
        return ((Data)this.key).getHeapCost() + ((Data)this.value).getHeapCost() + 16 + 8 + 12;
    }

    public boolean isExpired(long maxIdleMillis, long timeToLiveMillis) {
        long time = Clock.currentTimeMillis();
        return maxIdleMillis > 0L && time > this.lastAccessTime + maxIdleMillis || timeToLiveMillis > 0L && time > this.creationTime + timeToLiveMillis;
    }

    public static Comparator<NearCacheRecord> getComparator(EvictionPolicy evictionPolicy) {
        if (EvictionPolicy.LRU.equals((Object)evictionPolicy)) {
            return LRU_COMPARATOR;
        }
        if (EvictionPolicy.LFU.equals((Object)evictionPolicy)) {
            return LFU_COMPARATOR;
        }
        return DEFAULT_COMPARATOR;
    }
}

