// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/build/v1/publish_build_event.proto

package com.google.devtools.build.v1;

/**
 * <pre>
 * Publishes 'lifecycle events' that update the high-level state of a build:
 * - BuildEnqueued: When a build is scheduled.
 * - InvocationAttemptStarted: When work for a build starts; there can be
 *     multiple invocations for a build (e.g. retries).
 * - InvocationAttemptCompleted: When work for a build finishes.
 * - BuildFinished: When a build is finished.
 * </pre>
 *
 * Protobuf type {@code google.devtools.build.v1.PublishLifecycleEventRequest}
 */
public  final class PublishLifecycleEventRequest extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.devtools.build.v1.PublishLifecycleEventRequest)
    PublishLifecycleEventRequestOrBuilder {
private static final long serialVersionUID = 0L;
  // Use PublishLifecycleEventRequest.newBuilder() to construct.
  private PublishLifecycleEventRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private PublishLifecycleEventRequest() {
    serviceLevel_ = 0;
    notificationKeywords_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    projectId_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private PublishLifecycleEventRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();

            serviceLevel_ = rawValue;
            break;
          }
          case 18: {
            com.google.devtools.build.v1.OrderedBuildEvent.Builder subBuilder = null;
            if (buildEvent_ != null) {
              subBuilder = buildEvent_.toBuilder();
            }
            buildEvent_ = input.readMessage(com.google.devtools.build.v1.OrderedBuildEvent.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(buildEvent_);
              buildEvent_ = subBuilder.buildPartial();
            }

            break;
          }
          case 26: {
            com.google.protobuf.Duration.Builder subBuilder = null;
            if (streamTimeout_ != null) {
              subBuilder = streamTimeout_.toBuilder();
            }
            streamTimeout_ = input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(streamTimeout_);
              streamTimeout_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
              notificationKeywords_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000008;
            }
            notificationKeywords_.add(s);
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();

            projectId_ = s;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
        notificationKeywords_ = notificationKeywords_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.devtools.build.v1.BackendProto.internal_static_google_devtools_build_v1_PublishLifecycleEventRequest_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.build.v1.BackendProto.internal_static_google_devtools_build_v1_PublishLifecycleEventRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.build.v1.PublishLifecycleEventRequest.class, com.google.devtools.build.v1.PublishLifecycleEventRequest.Builder.class);
  }

  /**
   * <pre>
   * The service level of the build request. Backends only uses this value when
   * the BuildEnqueued event is published to determine what level of service
   * this build should receive.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel}
   */
  public enum ServiceLevel
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Non-interactive builds can tolerate longer event latencies. This is the
     * default ServiceLevel if callers do not specify one.
     * </pre>
     *
     * <code>NONINTERACTIVE = 0;</code>
     */
    NONINTERACTIVE(0),
    /**
     * <pre>
     * The events of an interactive build should be delivered with low latency.
     * </pre>
     *
     * <code>INTERACTIVE = 1;</code>
     */
    INTERACTIVE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Non-interactive builds can tolerate longer event latencies. This is the
     * default ServiceLevel if callers do not specify one.
     * </pre>
     *
     * <code>NONINTERACTIVE = 0;</code>
     */
    public static final int NONINTERACTIVE_VALUE = 0;
    /**
     * <pre>
     * The events of an interactive build should be delivered with low latency.
     * </pre>
     *
     * <code>INTERACTIVE = 1;</code>
     */
    public static final int INTERACTIVE_VALUE = 1;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ServiceLevel valueOf(int value) {
      return forNumber(value);
    }

    public static ServiceLevel forNumber(int value) {
      switch (value) {
        case 0: return NONINTERACTIVE;
        case 1: return INTERACTIVE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ServiceLevel>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ServiceLevel> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ServiceLevel>() {
            public ServiceLevel findValueByNumber(int number) {
              return ServiceLevel.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.devtools.build.v1.PublishLifecycleEventRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final ServiceLevel[] VALUES = values();

    public static ServiceLevel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ServiceLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel)
  }

  private int bitField0_;
  public static final int SERVICE_LEVEL_FIELD_NUMBER = 1;
  private int serviceLevel_;
  /**
   * <pre>
   * The interactivity of this build.
   * </pre>
   *
   * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
   */
  public int getServiceLevelValue() {
    return serviceLevel_;
  }
  /**
   * <pre>
   * The interactivity of this build.
   * </pre>
   *
   * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
   */
  public com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel getServiceLevel() {
    com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel result = com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.valueOf(serviceLevel_);
    return result == null ? com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.UNRECOGNIZED : result;
  }

  public static final int BUILD_EVENT_FIELD_NUMBER = 2;
  private com.google.devtools.build.v1.OrderedBuildEvent buildEvent_;
  /**
   * <pre>
   * The lifecycle build event. If this is a build tool event, the RPC will fail
   * with INVALID_REQUEST.
   * </pre>
   *
   * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
   */
  public boolean hasBuildEvent() {
    return buildEvent_ != null;
  }
  /**
   * <pre>
   * The lifecycle build event. If this is a build tool event, the RPC will fail
   * with INVALID_REQUEST.
   * </pre>
   *
   * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
   */
  public com.google.devtools.build.v1.OrderedBuildEvent getBuildEvent() {
    return buildEvent_ == null ? com.google.devtools.build.v1.OrderedBuildEvent.getDefaultInstance() : buildEvent_;
  }
  /**
   * <pre>
   * The lifecycle build event. If this is a build tool event, the RPC will fail
   * with INVALID_REQUEST.
   * </pre>
   *
   * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
   */
  public com.google.devtools.build.v1.OrderedBuildEventOrBuilder getBuildEventOrBuilder() {
    return getBuildEvent();
  }

  public static final int STREAM_TIMEOUT_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration streamTimeout_;
  /**
   * <pre>
   * If the next event for this build or invocation (depending on the event
   * type) hasn't been published after this duration from when {build_event}
   * is written to BES, consider this stream expired. If this field is not set,
   * BES backend will use its own default value.
   * </pre>
   *
   * <code>.google.protobuf.Duration stream_timeout = 3;</code>
   */
  public boolean hasStreamTimeout() {
    return streamTimeout_ != null;
  }
  /**
   * <pre>
   * If the next event for this build or invocation (depending on the event
   * type) hasn't been published after this duration from when {build_event}
   * is written to BES, consider this stream expired. If this field is not set,
   * BES backend will use its own default value.
   * </pre>
   *
   * <code>.google.protobuf.Duration stream_timeout = 3;</code>
   */
  public com.google.protobuf.Duration getStreamTimeout() {
    return streamTimeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : streamTimeout_;
  }
  /**
   * <pre>
   * If the next event for this build or invocation (depending on the event
   * type) hasn't been published after this duration from when {build_event}
   * is written to BES, consider this stream expired. If this field is not set,
   * BES backend will use its own default value.
   * </pre>
   *
   * <code>.google.protobuf.Duration stream_timeout = 3;</code>
   */
  public com.google.protobuf.DurationOrBuilder getStreamTimeoutOrBuilder() {
    return getStreamTimeout();
  }

  public static final int NOTIFICATION_KEYWORDS_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList notificationKeywords_;
  /**
   * <pre>
   * Additional information about a build request. These are define by the event
   * publishers, and the Build Event Service does not validate or interpret
   * them. They are used while notifying internal systems of new builds and
   * invocations if the OrderedBuildEvent.event type is
   * BuildEnqueued/InvocationAttemptStarted.
   * </pre>
   *
   * <code>repeated string notification_keywords = 4;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getNotificationKeywordsList() {
    return notificationKeywords_;
  }
  /**
   * <pre>
   * Additional information about a build request. These are define by the event
   * publishers, and the Build Event Service does not validate or interpret
   * them. They are used while notifying internal systems of new builds and
   * invocations if the OrderedBuildEvent.event type is
   * BuildEnqueued/InvocationAttemptStarted.
   * </pre>
   *
   * <code>repeated string notification_keywords = 4;</code>
   */
  public int getNotificationKeywordsCount() {
    return notificationKeywords_.size();
  }
  /**
   * <pre>
   * Additional information about a build request. These are define by the event
   * publishers, and the Build Event Service does not validate or interpret
   * them. They are used while notifying internal systems of new builds and
   * invocations if the OrderedBuildEvent.event type is
   * BuildEnqueued/InvocationAttemptStarted.
   * </pre>
   *
   * <code>repeated string notification_keywords = 4;</code>
   */
  public java.lang.String getNotificationKeywords(int index) {
    return notificationKeywords_.get(index);
  }
  /**
   * <pre>
   * Additional information about a build request. These are define by the event
   * publishers, and the Build Event Service does not validate or interpret
   * them. They are used while notifying internal systems of new builds and
   * invocations if the OrderedBuildEvent.event type is
   * BuildEnqueued/InvocationAttemptStarted.
   * </pre>
   *
   * <code>repeated string notification_keywords = 4;</code>
   */
  public com.google.protobuf.ByteString
      getNotificationKeywordsBytes(int index) {
    return notificationKeywords_.getByteString(index);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 6;
  private volatile java.lang.Object projectId_;
  /**
   * <pre>
   * This field identifies which project (if any) the build is associated with.
   * </pre>
   *
   * <code>string project_id = 6;</code>
   */
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * This field identifies which project (if any) the build is associated with.
   * </pre>
   *
   * <code>string project_id = 6;</code>
   */
  public com.google.protobuf.ByteString
      getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (serviceLevel_ != com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.NONINTERACTIVE.getNumber()) {
      output.writeEnum(1, serviceLevel_);
    }
    if (buildEvent_ != null) {
      output.writeMessage(2, getBuildEvent());
    }
    if (streamTimeout_ != null) {
      output.writeMessage(3, getStreamTimeout());
    }
    for (int i = 0; i < notificationKeywords_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, notificationKeywords_.getRaw(i));
    }
    if (!getProjectIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, projectId_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (serviceLevel_ != com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.NONINTERACTIVE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, serviceLevel_);
    }
    if (buildEvent_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getBuildEvent());
    }
    if (streamTimeout_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getStreamTimeout());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < notificationKeywords_.size(); i++) {
        dataSize += computeStringSizeNoTag(notificationKeywords_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNotificationKeywordsList().size();
    }
    if (!getProjectIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, projectId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.devtools.build.v1.PublishLifecycleEventRequest)) {
      return super.equals(obj);
    }
    com.google.devtools.build.v1.PublishLifecycleEventRequest other = (com.google.devtools.build.v1.PublishLifecycleEventRequest) obj;

    boolean result = true;
    result = result && serviceLevel_ == other.serviceLevel_;
    result = result && (hasBuildEvent() == other.hasBuildEvent());
    if (hasBuildEvent()) {
      result = result && getBuildEvent()
          .equals(other.getBuildEvent());
    }
    result = result && (hasStreamTimeout() == other.hasStreamTimeout());
    if (hasStreamTimeout()) {
      result = result && getStreamTimeout()
          .equals(other.getStreamTimeout());
    }
    result = result && getNotificationKeywordsList()
        .equals(other.getNotificationKeywordsList());
    result = result && getProjectId()
        .equals(other.getProjectId());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + serviceLevel_;
    if (hasBuildEvent()) {
      hash = (37 * hash) + BUILD_EVENT_FIELD_NUMBER;
      hash = (53 * hash) + getBuildEvent().hashCode();
    }
    if (hasStreamTimeout()) {
      hash = (37 * hash) + STREAM_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getStreamTimeout().hashCode();
    }
    if (getNotificationKeywordsCount() > 0) {
      hash = (37 * hash) + NOTIFICATION_KEYWORDS_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationKeywordsList().hashCode();
    }
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.devtools.build.v1.PublishLifecycleEventRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.devtools.build.v1.PublishLifecycleEventRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Publishes 'lifecycle events' that update the high-level state of a build:
   * - BuildEnqueued: When a build is scheduled.
   * - InvocationAttemptStarted: When work for a build starts; there can be
   *     multiple invocations for a build (e.g. retries).
   * - InvocationAttemptCompleted: When work for a build finishes.
   * - BuildFinished: When a build is finished.
   * </pre>
   *
   * Protobuf type {@code google.devtools.build.v1.PublishLifecycleEventRequest}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.devtools.build.v1.PublishLifecycleEventRequest)
      com.google.devtools.build.v1.PublishLifecycleEventRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.devtools.build.v1.BackendProto.internal_static_google_devtools_build_v1_PublishLifecycleEventRequest_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.build.v1.BackendProto.internal_static_google_devtools_build_v1_PublishLifecycleEventRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.build.v1.PublishLifecycleEventRequest.class, com.google.devtools.build.v1.PublishLifecycleEventRequest.Builder.class);
    }

    // Construct using com.google.devtools.build.v1.PublishLifecycleEventRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      serviceLevel_ = 0;

      if (buildEventBuilder_ == null) {
        buildEvent_ = null;
      } else {
        buildEvent_ = null;
        buildEventBuilder_ = null;
      }
      if (streamTimeoutBuilder_ == null) {
        streamTimeout_ = null;
      } else {
        streamTimeout_ = null;
        streamTimeoutBuilder_ = null;
      }
      notificationKeywords_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      projectId_ = "";

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.devtools.build.v1.BackendProto.internal_static_google_devtools_build_v1_PublishLifecycleEventRequest_descriptor;
    }

    public com.google.devtools.build.v1.PublishLifecycleEventRequest getDefaultInstanceForType() {
      return com.google.devtools.build.v1.PublishLifecycleEventRequest.getDefaultInstance();
    }

    public com.google.devtools.build.v1.PublishLifecycleEventRequest build() {
      com.google.devtools.build.v1.PublishLifecycleEventRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.devtools.build.v1.PublishLifecycleEventRequest buildPartial() {
      com.google.devtools.build.v1.PublishLifecycleEventRequest result = new com.google.devtools.build.v1.PublishLifecycleEventRequest(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.serviceLevel_ = serviceLevel_;
      if (buildEventBuilder_ == null) {
        result.buildEvent_ = buildEvent_;
      } else {
        result.buildEvent_ = buildEventBuilder_.build();
      }
      if (streamTimeoutBuilder_ == null) {
        result.streamTimeout_ = streamTimeout_;
      } else {
        result.streamTimeout_ = streamTimeoutBuilder_.build();
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        notificationKeywords_ = notificationKeywords_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.notificationKeywords_ = notificationKeywords_;
      result.projectId_ = projectId_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.build.v1.PublishLifecycleEventRequest) {
        return mergeFrom((com.google.devtools.build.v1.PublishLifecycleEventRequest)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.build.v1.PublishLifecycleEventRequest other) {
      if (other == com.google.devtools.build.v1.PublishLifecycleEventRequest.getDefaultInstance()) return this;
      if (other.serviceLevel_ != 0) {
        setServiceLevelValue(other.getServiceLevelValue());
      }
      if (other.hasBuildEvent()) {
        mergeBuildEvent(other.getBuildEvent());
      }
      if (other.hasStreamTimeout()) {
        mergeStreamTimeout(other.getStreamTimeout());
      }
      if (!other.notificationKeywords_.isEmpty()) {
        if (notificationKeywords_.isEmpty()) {
          notificationKeywords_ = other.notificationKeywords_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureNotificationKeywordsIsMutable();
          notificationKeywords_.addAll(other.notificationKeywords_);
        }
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.devtools.build.v1.PublishLifecycleEventRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.devtools.build.v1.PublishLifecycleEventRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private int serviceLevel_ = 0;
    /**
     * <pre>
     * The interactivity of this build.
     * </pre>
     *
     * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
     */
    public int getServiceLevelValue() {
      return serviceLevel_;
    }
    /**
     * <pre>
     * The interactivity of this build.
     * </pre>
     *
     * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
     */
    public Builder setServiceLevelValue(int value) {
      serviceLevel_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The interactivity of this build.
     * </pre>
     *
     * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
     */
    public com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel getServiceLevel() {
      com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel result = com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.valueOf(serviceLevel_);
      return result == null ? com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The interactivity of this build.
     * </pre>
     *
     * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
     */
    public Builder setServiceLevel(com.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      serviceLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The interactivity of this build.
     * </pre>
     *
     * <code>.google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel service_level = 1;</code>
     */
    public Builder clearServiceLevel() {
      
      serviceLevel_ = 0;
      onChanged();
      return this;
    }

    private com.google.devtools.build.v1.OrderedBuildEvent buildEvent_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.devtools.build.v1.OrderedBuildEvent, com.google.devtools.build.v1.OrderedBuildEvent.Builder, com.google.devtools.build.v1.OrderedBuildEventOrBuilder> buildEventBuilder_;
    /**
     * <pre>
     * The lifecycle build event. If this is a build tool event, the RPC will fail
     * with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
     */
    public boolean hasBuildEvent() {
      return buildEventBuilder_ != null || buildEvent_ != null;
    }
    /**
     * <pre>
     * The lifecycle build event. If this is a build tool event, the RPC will fail
     * with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
     */
    public com.google.devtools.build.v1.OrderedBuildEvent getBuildEvent() {
      if (buildEventBuilder_ == null) {
        return buildEvent_ == null ? com.google.devtools.build.v1.OrderedBuildEvent.getDefaultInstance() : buildEvent_;
      } else {
        return buildEventBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The lifecycle build event. If this is a build tool event, the RPC will fail
     * with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
     */
    public Builder setBuildEvent(com.google.devtools.build.v1.OrderedBuildEvent value) {
      if (buildEventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        buildEvent_ = value;
        onChanged();
      } else {
        buildEventBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The lifecycle build event. If this is a build tool event, the RPC will fail
     * with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
     */
    public Builder setBuildEvent(
        com.google.devtools.build.v1.OrderedBuildEvent.Builder builderForValue) {
      if (buildEventBuilder_ == null) {
        buildEvent_ = builderForValue.build();
        onChanged();
      } else {
        buildEventBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The lifecycle build event. If this is a build tool event, the RPC will fail
     * with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
     */
    public Builder mergeBuildEvent(com.google.devtools.build.v1.OrderedBuildEvent value) {
      if (buildEventBuilder_ == null) {
        if (buildEvent_ != null) {
          buildEvent_ =
            com.google.devtools.build.v1.OrderedBuildEvent.newBuilder(buildEvent_).mergeFrom(value).buildPartial();
        } else {
          buildEvent_ = value;
        }
        onChanged();
      } else {
        buildEventBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The lifecycle build event. If this is a build tool event, the RPC will fail
     * with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
     */
    public Builder clearBuildEvent() {
      if (buildEventBuilder_ == null) {
        buildEvent_ = null;
        onChanged();
      } else {
        buildEvent_ = null;
        buildEventBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The lifecycle build event. If this is a build tool event, the RPC will fail
     * with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
     */
    public com.google.devtools.build.v1.OrderedBuildEvent.Builder getBuildEventBuilder() {
      
      onChanged();
      return getBuildEventFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The lifecycle build event. If this is a build tool event, the RPC will fail
     * with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
     */
    public com.google.devtools.build.v1.OrderedBuildEventOrBuilder getBuildEventOrBuilder() {
      if (buildEventBuilder_ != null) {
        return buildEventBuilder_.getMessageOrBuilder();
      } else {
        return buildEvent_ == null ?
            com.google.devtools.build.v1.OrderedBuildEvent.getDefaultInstance() : buildEvent_;
      }
    }
    /**
     * <pre>
     * The lifecycle build event. If this is a build tool event, the RPC will fail
     * with INVALID_REQUEST.
     * </pre>
     *
     * <code>.google.devtools.build.v1.OrderedBuildEvent build_event = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.devtools.build.v1.OrderedBuildEvent, com.google.devtools.build.v1.OrderedBuildEvent.Builder, com.google.devtools.build.v1.OrderedBuildEventOrBuilder> 
        getBuildEventFieldBuilder() {
      if (buildEventBuilder_ == null) {
        buildEventBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.build.v1.OrderedBuildEvent, com.google.devtools.build.v1.OrderedBuildEvent.Builder, com.google.devtools.build.v1.OrderedBuildEventOrBuilder>(
                getBuildEvent(),
                getParentForChildren(),
                isClean());
        buildEvent_ = null;
      }
      return buildEventBuilder_;
    }

    private com.google.protobuf.Duration streamTimeout_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> streamTimeoutBuilder_;
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public boolean hasStreamTimeout() {
      return streamTimeoutBuilder_ != null || streamTimeout_ != null;
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public com.google.protobuf.Duration getStreamTimeout() {
      if (streamTimeoutBuilder_ == null) {
        return streamTimeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : streamTimeout_;
      } else {
        return streamTimeoutBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public Builder setStreamTimeout(com.google.protobuf.Duration value) {
      if (streamTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamTimeout_ = value;
        onChanged();
      } else {
        streamTimeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public Builder setStreamTimeout(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (streamTimeoutBuilder_ == null) {
        streamTimeout_ = builderForValue.build();
        onChanged();
      } else {
        streamTimeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public Builder mergeStreamTimeout(com.google.protobuf.Duration value) {
      if (streamTimeoutBuilder_ == null) {
        if (streamTimeout_ != null) {
          streamTimeout_ =
            com.google.protobuf.Duration.newBuilder(streamTimeout_).mergeFrom(value).buildPartial();
        } else {
          streamTimeout_ = value;
        }
        onChanged();
      } else {
        streamTimeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public Builder clearStreamTimeout() {
      if (streamTimeoutBuilder_ == null) {
        streamTimeout_ = null;
        onChanged();
      } else {
        streamTimeout_ = null;
        streamTimeoutBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getStreamTimeoutBuilder() {
      
      onChanged();
      return getStreamTimeoutFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getStreamTimeoutOrBuilder() {
      if (streamTimeoutBuilder_ != null) {
        return streamTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return streamTimeout_ == null ?
            com.google.protobuf.Duration.getDefaultInstance() : streamTimeout_;
      }
    }
    /**
     * <pre>
     * If the next event for this build or invocation (depending on the event
     * type) hasn't been published after this duration from when {build_event}
     * is written to BES, consider this stream expired. If this field is not set,
     * BES backend will use its own default value.
     * </pre>
     *
     * <code>.google.protobuf.Duration stream_timeout = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> 
        getStreamTimeoutFieldBuilder() {
      if (streamTimeoutBuilder_ == null) {
        streamTimeoutBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder>(
                getStreamTimeout(),
                getParentForChildren(),
                isClean());
        streamTimeout_ = null;
      }
      return streamTimeoutBuilder_;
    }

    private com.google.protobuf.LazyStringList notificationKeywords_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureNotificationKeywordsIsMutable() {
      if (!((bitField0_ & 0x00000008) == 0x00000008)) {
        notificationKeywords_ = new com.google.protobuf.LazyStringArrayList(notificationKeywords_);
        bitField0_ |= 0x00000008;
       }
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getNotificationKeywordsList() {
      return notificationKeywords_.getUnmodifiableView();
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     */
    public int getNotificationKeywordsCount() {
      return notificationKeywords_.size();
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     */
    public java.lang.String getNotificationKeywords(int index) {
      return notificationKeywords_.get(index);
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     */
    public com.google.protobuf.ByteString
        getNotificationKeywordsBytes(int index) {
      return notificationKeywords_.getByteString(index);
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     */
    public Builder setNotificationKeywords(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureNotificationKeywordsIsMutable();
      notificationKeywords_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     */
    public Builder addNotificationKeywords(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureNotificationKeywordsIsMutable();
      notificationKeywords_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     */
    public Builder addAllNotificationKeywords(
        java.lang.Iterable<java.lang.String> values) {
      ensureNotificationKeywordsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, notificationKeywords_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     */
    public Builder clearNotificationKeywords() {
      notificationKeywords_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Additional information about a build request. These are define by the event
     * publishers, and the Build Event Service does not validate or interpret
     * them. They are used while notifying internal systems of new builds and
     * invocations if the OrderedBuildEvent.event type is
     * BuildEnqueued/InvocationAttemptStarted.
     * </pre>
     *
     * <code>repeated string notification_keywords = 4;</code>
     */
    public Builder addNotificationKeywordsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureNotificationKeywordsIsMutable();
      notificationKeywords_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     * <pre>
     * This field identifies which project (if any) the build is associated with.
     * </pre>
     *
     * <code>string project_id = 6;</code>
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * This field identifies which project (if any) the build is associated with.
     * </pre>
     *
     * <code>string project_id = 6;</code>
     */
    public com.google.protobuf.ByteString
        getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * This field identifies which project (if any) the build is associated with.
     * </pre>
     *
     * <code>string project_id = 6;</code>
     */
    public Builder setProjectId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This field identifies which project (if any) the build is associated with.
     * </pre>
     *
     * <code>string project_id = 6;</code>
     */
    public Builder clearProjectId() {
      
      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This field identifies which project (if any) the build is associated with.
     * </pre>
     *
     * <code>string project_id = 6;</code>
     */
    public Builder setProjectIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      projectId_ = value;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.devtools.build.v1.PublishLifecycleEventRequest)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.build.v1.PublishLifecycleEventRequest)
  private static final com.google.devtools.build.v1.PublishLifecycleEventRequest DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.devtools.build.v1.PublishLifecycleEventRequest();
  }

  public static com.google.devtools.build.v1.PublishLifecycleEventRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PublishLifecycleEventRequest>
      PARSER = new com.google.protobuf.AbstractParser<PublishLifecycleEventRequest>() {
    public PublishLifecycleEventRequest parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new PublishLifecycleEventRequest(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<PublishLifecycleEventRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PublishLifecycleEventRequest> getParserForType() {
    return PARSER;
  }

  public com.google.devtools.build.v1.PublishLifecycleEventRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

