/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.client;

import com.hazelcast.core.IFunction;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.ringbuffer.impl.ReadResultSetImpl;
import com.hazelcast.ringbuffer.impl.client.PortableReadResultSet;
import com.hazelcast.ringbuffer.impl.client.RingbufferRequest;
import com.hazelcast.ringbuffer.impl.operations.ReadManyOperation;
import com.hazelcast.security.permission.RingBufferPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;

public class ReadManyRequest
extends RingbufferRequest {
    private long startSequence;
    private int minCount;
    private int maxCount;
    private Data filterData;

    public ReadManyRequest() {
    }

    public ReadManyRequest(String name, long startSequence, int minCount, int maxCount, Data filter) {
        this.name = name;
        this.startSequence = startSequence;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.filterData = filter;
    }

    @Override
    protected Operation prepareOperation() {
        SerializationService serializationService = this.getClientEngine().getSerializationService();
        IFunction filter = (IFunction)serializationService.toObject(this.filterData);
        return new ReadManyOperation(this.name, this.startSequence, this.minCount, this.maxCount, filter);
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    protected Object filter(Object response) {
        ReadResultSetImpl readResultSet = (ReadResultSetImpl)response;
        int size = readResultSet.size();
        ArrayList<Data> items = new ArrayList<Data>(size);
        Data[] dataItems = readResultSet.getDataItems();
        for (int k = 0; k < size; ++k) {
            items.add(dataItems[k]);
        }
        int readCount = readResultSet.readCount();
        return new PortableReadResultSet(readCount, items);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeLong("s", this.startSequence);
        writer.writeInt("i", this.minCount);
        writer.writeInt("a", this.maxCount);
        writer.getRawDataOutput().writeData(this.filterData);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.startSequence = reader.readLong("s");
        this.minCount = reader.readInt("i");
        this.maxCount = reader.readInt("a");
        this.filterData = reader.getRawDataInput().readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new RingBufferPermission(this.name, "read");
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.startSequence, this.minCount, this.maxCount, null};
    }

    @Override
    public String getMethodName() {
        return "readMany";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

