/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.impl.BaseMigrationOperation;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public final class MigrationOperation
extends BaseMigrationOperation {
    private static final OperationResponseHandler ERROR_RESPONSE_HANDLER = new OperationResponseHandler(){

        public void sendResponse(Operation op, Object obj) {
            throw new HazelcastException("Migration operations can not send response!");
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    };
    private long[] replicaVersions;
    private Collection<Operation> tasks;
    private Throwable failureReason;

    public MigrationOperation() {
    }

    public MigrationOperation(MigrationInfo migrationInfo, long[] replicaVersions, Collection<Operation> tasks) {
        super(migrationInfo);
        this.replicaVersions = replicaVersions;
        this.tasks = tasks;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        this.assertMigrationInitiatorIsMaster();
        try {
            this.doRun();
        }
        catch (Throwable t) {
            this.logMigrationFailure(t);
            this.failureReason = t;
        }
        finally {
            if (!this.success) {
                this.onExecutionFailure(this.failureReason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() throws Exception {
        if (this.startMigration()) {
            try {
                this.migrate();
            }
            catch (Throwable e) {
                this.success = false;
                this.failureReason = e;
                this.getLogger().severe("Error while processing " + this.migrationInfo, e);
            }
            finally {
                this.afterMigrate();
            }
        } else {
            this.success = false;
            this.logMigrationCancelled();
        }
    }

    private void assertMigrationInitiatorIsMaster() {
        Address masterAddress = this.getNodeEngine().getMasterAddress();
        if (!masterAddress.equals(this.migrationInfo.getMaster())) {
            throw new RetryableHazelcastException("Migration initiator is not master node! => " + this.toString());
        }
    }

    private boolean startMigration() {
        return this.migrationInfo.startProcessing();
    }

    private void logMigrationCancelled() {
        this.getLogger().warning("Migration is cancelled -> " + this.migrationInfo);
    }

    private void afterMigrate() {
        if (this.success) {
            InternalPartitionService partitionService = (InternalPartitionService)this.getService();
            partitionService.setPartitionReplicaVersions(this.migrationInfo.getPartitionId(), this.replicaVersions, 1);
            if (this.getLogger().isFinestEnabled()) {
                this.getLogger().finest("ReplicaVersions are set after migration. partitionId=" + this.migrationInfo.getPartitionId() + " replicaVersions=" + Arrays.toString(this.replicaVersions));
            }
        } else if (this.getLogger().isFinestEnabled()) {
            this.getLogger().finest("ReplicaVersions are not set since migration failed. partitionId=" + this.migrationInfo.getPartitionId());
        }
        this.migrationInfo.doneProcessing();
    }

    private void logMigrationFailure(Throwable e) {
        ILogger logger;
        Level level = Level.WARNING;
        if (e instanceof IllegalStateException) {
            level = Level.FINEST;
        }
        if ((logger = this.getLogger()).isLoggable(level)) {
            logger.log(level, e.getMessage(), e);
        }
    }

    private void migrate() throws Exception {
        this.addActiveMigration();
        for (Operation op : this.tasks) {
            this.prepareOperation(op);
            try {
                this.runMigrationTask(op);
            }
            catch (Throwable e) {
                this.getLogger().severe("An exception occurred while executing migration operation " + op, e);
                this.success = false;
                this.failureReason = e;
                return;
            }
        }
        this.success = true;
    }

    private void addActiveMigration() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        partitionService.addActiveMigration(this.migrationInfo);
    }

    private void runMigrationTask(Operation op) throws Exception {
        MigrationAwareService service = (MigrationAwareService)op.getService();
        PartitionMigrationEvent event = new PartitionMigrationEvent(MigrationEndpoint.DESTINATION, this.migrationInfo.getPartitionId());
        service.beforeMigration(event);
        op.beforeRun();
        op.run();
        op.afterRun();
    }

    private void prepareOperation(Operation op) {
        op.setNodeEngine(this.getNodeEngine()).setPartitionId(this.getPartitionId()).setReplicaIndex(this.getReplicaIndex());
        op.setOperationResponseHandler(ERROR_RESPONSE_HANDLER);
        OperationAccessor.setCallerAddress(op, this.migrationInfo.getSource());
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.tasks != null) {
            for (Operation op : this.tasks) {
                this.prepareOperation(op);
                this.onOperationFailure(op, e);
            }
        }
    }

    private void onOperationFailure(Operation op, Throwable e) {
        try {
            op.onExecutionFailure(e);
        }
        catch (Throwable t) {
            this.getLogger().warning("While calling operation.onFailure(). op: " + op, t);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLongArray(this.replicaVersions);
        int size = this.tasks != null ? this.tasks.size() : 0;
        out.writeInt(size);
        if (size > 0) {
            for (Operation task : this.tasks) {
                out.writeObject(task);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.replicaVersions = in.readLongArray();
        int size = in.readInt();
        if (size > 0) {
            this.tasks = new ArrayList<Operation>(size);
            for (int i = 0; i < size; ++i) {
                Operation op = (Operation)in.readObject();
                this.tasks.add(op);
            }
        } else {
            this.tasks = Collections.emptyList();
        }
    }

    @Override
    protected void toString(StringBuilder sb) {
        int numberOfTasks = this.tasks == null ? 0 : this.tasks.size();
        sb.append(", migration=").append(this.migrationInfo);
        sb.append(", replicaVersions=").append(Arrays.toString(this.replicaVersions));
        sb.append(", numberOfTasks=").append(numberOfTasks);
    }
}

